/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.structure;

import java.util.ArrayList;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;

public class PetriNetTransformations<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition> {
    public void relinkIncomingArcs(IPetriNet<F, N, P, T> net, N from, N to) {
        for (IFlow f : net.getIncomingEdges((IVertex)from)) {
            net.addFlow((INode)f.getSource(), to);
            net.removeFlow(f);
        }
    }

    public void relinkOutgoingArcs(IPetriNet<F, N, P, T> net, N from, N to) {
        for (IFlow f : net.getOutgoingEdges((IVertex)from)) {
            net.addFlow(to, (INode)f.getTarget());
            net.removeFlow(f);
        }
    }

    public void isolateTransitions(IPetriNet<F, N, P, T> net) {
        ArrayList<T> ts = new ArrayList<T>(net.getTransitions());
        for (ITransition t : ts) {
            T newT;
            P newP;
            if (net.getDirectPredecessors(t).size() > 1) {
                newP = net.createPlace();
                newT = net.createTransition();
                this.relinkIncomingArcs(net, t, newT);
                net.addFlow(newT, (ITransition)newP);
                net.addFlow(newP, t);
            }
            if (net.getDirectSuccessors(t).size() <= 1) continue;
            newP = net.createPlace();
            newT = net.createTransition();
            this.relinkOutgoingArcs(net, t, newT);
            net.addFlow((T)t, (ITransition)newP);
            net.addFlow((T)newP, (ITransition)newT);
        }
    }

    public void tRestrict(IPetriNet<F, N, P, T> net) {
        for (ITransition t : net.getSourceTransitions()) {
            net.addFlow((ITransition)net.createPlace(), t);
        }
        for (ITransition t : net.getSinkTransitions()) {
            net.addFlow(t, (ITransition)net.createPlace());
        }
    }
}

