/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpt.algo.ListCombinationGenerator;
import org.jbpt.algo.MultiSetUtils;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.AbstractCoSet;
import org.jbpt.petri.unfolding.AbstractEvent;
import org.jbpt.petri.unfolding.BranchingProcess;
import org.jbpt.petri.unfolding.CoSet;
import org.jbpt.petri.unfolding.Condition;
import org.jbpt.petri.unfolding.Cut;
import org.jbpt.petri.unfolding.Event;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.IBranchingProcess;
import org.jbpt.petri.unfolding.ICoSet;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.ICut;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.IOccurrenceNet;
import org.jbpt.petri.unfolding.OccurrenceNet;
import org.jbpt.petri.unfolding.OrderingRelationType;

public abstract class AbstractBranchingProcess<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
implements IBranchingProcess<BPN, C, E, F, N, P, T, M> {
    protected INetSystem<F, N, P, T, M> sys = null;
    protected List<E> log = null;
    protected Set<E> events = null;
    protected Set<C> conds = null;
    protected ICut<BPN, C, E, F, N, P, T, M> iniBP = null;
    protected Map<BPN, Set<BPN>> ca = null;
    protected Map<BPN, Set<BPN>> co = null;
    private Map<BPN, Set<BPN>> EX = null;
    private Map<BPN, Set<BPN>> notEX = null;
    private Map<BPN, Set<BPN>> CO = null;
    private Map<BPN, Set<BPN>> notCO = null;

    protected AbstractBranchingProcess() {
        this.initialize();
    }

    protected AbstractBranchingProcess(INetSystem<F, N, P, T, M> sys) {
        this.setNetSystem(sys);
    }

    protected void initialize() {
        this.log = new ArrayList();
        this.events = new HashSet();
        this.conds = new HashSet<C>();
        this.iniBP = this.createCut();
        this.ca = new HashMap<BPN, Set<BPN>>();
        this.co = new HashMap<BPN, Set<BPN>>();
        this.EX = new HashMap<BPN, Set<BPN>>();
        this.notEX = new HashMap<BPN, Set<BPN>>();
        this.CO = new HashMap<BPN, Set<BPN>>();
        this.notCO = new HashMap<BPN, Set<BPN>>();
    }

    @Override
    public void constructInitialBranchingProcess() {
        if (!this.conds.isEmpty()) {
            return;
        }
        for (IPlace p : this.sys.getMarking().toMultiSet()) {
            C c = this.createCondition(p, null);
            this.appendCondition(c);
            this.iniBP.add(c);
        }
    }

    @Override
    public Set<C> getConditions() {
        return this.conds;
    }

    @Override
    public Set<C> getConditions(P place) {
        HashSet<ICondition> result = new HashSet<ICondition>();
        for (ICondition c : this.conds) {
            if (!c.getPlace().equals(place)) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public Set<E> getEvents() {
        return this.events;
    }

    @Override
    public Set<E> getEvents(T transition) {
        HashSet<IEvent> result = new HashSet<IEvent>();
        for (IEvent e : this.events) {
            if (!e.getTransition().equals(transition)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public INetSystem<F, N, P, T, M> getOriginativeNetSystem() {
        return this.sys;
    }

    @Override
    public boolean areCausal(BPN n1, BPN n2) {
        if (this.ca.get(n2) == null) {
            if (n2 instanceof AbstractEvent) {
                IEvent e = (IEvent)n2;
                if (e.getPreConditions().contains(n1)) {
                    return true;
                }
                for (ICondition c : e.getPreConditions()) {
                    if (!this.ca.get(c).contains(n1)) continue;
                    return true;
                }
                return false;
            }
            ICondition c = (ICondition)n2;
            if (c.getPreEvent().equals(n1)) {
                return true;
            }
            return this.ca.get(c.getPreEvent()).contains(n1);
        }
        return this.ca.get(n2).contains(n1);
    }

    @Override
    public boolean areInverseCausal(BPN n1, BPN n2) {
        return this.areCausal(n2, n1);
    }

    @Override
    public boolean areConcurrent(BPN n1, BPN n2) {
        boolean result;
        Set<BPN> co = this.CO.get(n1);
        if (co != null && co.contains(n2)) {
            return true;
        }
        Set<BPN> notCo = this.notCO.get(n1);
        if (notCo != null && notCo.contains(n2)) {
            return false;
        }
        boolean bl = result = !this.areCausal(n1, n2) && !this.areInverseCausal(n1, n2) && !this.areInConflict(n1, n2);
        if (result) {
            this.index(this.CO, n1, n2);
        } else {
            this.index(this.notCO, n1, n2);
        }
        return result;
    }

    @Override
    public boolean areInConflict(BPN n1, BPN n2) {
        Set<BPN> ex = this.EX.get(n1);
        if (ex != null && ex.contains(n2)) {
            return true;
        }
        Set<BPN> notEx = this.notEX.get(n1);
        if (notEx != null && notEx.contains(n2)) {
            return false;
        }
        if (n1.equals(n2)) {
            this.index(this.notEX, n1, n2);
            return false;
        }
        HashSet<BPN> ca1 = new HashSet<BPN>((Collection)this.ca.get(n1));
        ca1.add(n1);
        HashSet<BPN> ca2 = new HashSet<BPN>((Collection)this.ca.get(n2));
        ca2.add(n2);
        for (IBPNode nn1 : ca1) {
            if (nn1.isCondition()) continue;
            IEvent e1 = (IEvent)nn1;
            for (IBPNode nn2 : ca2) {
                IEvent e2;
                if (nn2.isCondition() || e1.equals(e2 = (IEvent)nn2) || !this.overlap(e1.getPreConditions(), e2.getPreConditions())) continue;
                this.index(this.EX, n1, n2);
                return true;
            }
        }
        this.index(this.notEX, n1, n2);
        return false;
    }

    @Override
    public OrderingRelationType getOrderingRelation(BPN n1, BPN n2) {
        if (this.areCausal(n1, n2)) {
            return OrderingRelationType.CAUSAL;
        }
        if (this.areInverseCausal(n1, n2)) {
            return OrderingRelationType.INVERSE_CAUSAL;
        }
        if (this.areInConflict(n1, n2)) {
            return OrderingRelationType.CONFLICT;
        }
        return OrderingRelationType.CONCURRENT;
    }

    @Override
    public C createCondition(P place, E event) {
        ICondition c = null;
        try {
            c = (ICondition)Condition.class.newInstance();
            c.setPlace(place);
            c.setPreEvent(event);
            return (C)c;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        return (C)c;
    }

    @Override
    public E createEvent(T transition, ICoSet<BPN, C, E, F, N, P, T, M> preConditions) {
        IEvent e = null;
        try {
            e = (IEvent)Event.class.newInstance();
            e.setTransition(transition);
            e.setPreConditions(preConditions);
            return (E)e;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        return (E)e;
    }

    @Override
    public boolean appendCondition(C condition) {
        this.conds.add(condition);
        this.updateCausalityCondition(condition);
        return true;
    }

    protected void updateCausalityCondition(C c) {
        Object e;
        if (this.ca.get(c) == null) {
            this.ca.put(c, new HashSet());
        }
        if ((e = c.getPreEvent()) == null) {
            return;
        }
        this.ca.get(c).addAll((Collection)this.ca.get(e));
        this.ca.get(c).add(e);
    }

    @Override
    public boolean appendEvent(E event) {
        this.events.add(event);
        this.updateCausalityEvent(event);
        ICoSet postConditions = null;
        try {
            postConditions = (ICoSet)AbstractCoSet.class.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        for (IPlace s : this.sys.getPostset(event.getTransition())) {
            C c = this.createCondition(s, event);
            postConditions.add(c);
            this.appendCondition(c);
        }
        event.setPostConditions(postConditions);
        this.log.add(event);
        return true;
    }

    @Override
    public boolean appendTransition(T transition) {
        ICoSet<BPN, C, ICondition, F, N, P, T, M> preset = this.createCoSet();
        Set<C> max = this.getMax();
        for (IPlace p : this.getOriginativeNetSystem().getPreset(transition)) {
            boolean flag = false;
            for (ICondition c : this.getMax()) {
                if (!c.getPlace().equals(p) || !max.contains(c)) continue;
                preset.add(c);
                max.remove(c);
                flag = true;
            }
            if (flag) continue;
            return false;
        }
        E e = this.createEvent(transition, preset);
        return this.appendEvent(e);
    }

    private void updateCausalityEvent(E e) {
        if (this.ca.get(e) == null) {
            this.ca.put(e, new HashSet());
        }
        for (ICondition c : e.getPreConditions()) {
            this.ca.get(e).addAll((Collection)this.ca.get(c));
        }
        for (ICondition c : e.getPreConditions()) {
            this.ca.get(e).add(c);
        }
    }

    private void index(Map<BPN, Set<BPN>> map, BPN n1, BPN n2) {
        Set<BPN> s1 = map.get(n1);
        if (s1 == null) {
            HashSet<BPN> ss1 = new HashSet<BPN>();
            ss1.add(n2);
            map.put(n1, ss1);
        } else {
            s1.add(n2);
        }
        Set<BPN> s2 = map.get(n2);
        if (s2 == null) {
            HashSet<BPN> ss2 = new HashSet<BPN>();
            ss2.add(n1);
            map.put(n2, ss2);
        } else {
            s2.add(n1);
        }
    }

    private boolean overlap(ICoSet<BPN, C, E, F, N, P, T, M> s1, ICoSet<BPN, C, E, F, N, P, T, M> s2) {
        for (ICondition n : s1) {
            if (!s2.contains(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICut<BPN, C, E, F, N, P, T, M> getInitialCut() {
        return this.iniBP;
    }

    @Override
    public ICoSet<BPN, C, E, F, N, P, T, M> createCoSet() {
        try {
            return (ICoSet)CoSet.class.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ICut<BPN, C, E, F, N, P, T, M> createCut() {
        try {
            return (ICut)Cut.class.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<BPN> getCausalPredecessors(BPN node) {
        return this.ca.get(node);
    }

    @Override
    public boolean isConflictFree() {
        HashMap<ICondition, IEvent> c2e = new HashMap<ICondition, IEvent>();
        for (IEvent e : this.events) {
            for (ICondition c : e.getPreConditions()) {
                if (c2e.get(c) != null) {
                    return false;
                }
                c2e.put(c, e);
            }
        }
        return true;
    }

    @Override
    public void setNetSystem(INetSystem<F, N, P, T, M> system) {
        if (system == null) {
            return;
        }
        this.sys = system;
        this.initialize();
    }

    @Override
    public boolean isSafe() {
        for (ICondition c1 : this.conds) {
            for (ICondition c2 : this.conds) {
                if (c1.equals(c2) || !c1.getPlace().equals(c2.getPlace()) || !this.areConcurrent(c1, c2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<C> getMin() {
        return this.iniBP;
    }

    @Override
    public Set<C> getMax() {
        HashSet<C> result = new HashSet<C>(this.conds);
        for (IEvent e : this.events) {
            result.removeAll(e.getPreConditions());
        }
        return result;
    }

    @Override
    public Set<P> getPlaces(Collection<C> conditions) {
        HashSet result = new HashSet();
        if (conditions == null) {
            return result;
        }
        for (ICondition c : conditions) {
            result.add(c.getPlace());
        }
        return result;
    }

    @Override
    public Set<T> getTransitions(Collection<E> events) {
        HashSet result = new HashSet();
        if (events == null) {
            return result;
        }
        for (IEvent e : events) {
            result.add(e.getTransition());
        }
        return result;
    }

    @Override
    public IOccurrenceNet<BPN, C, E, F, N, P, T, M> getOccurrenceNet() {
        try {
            IOccurrenceNet occ = (IOccurrenceNet)OccurrenceNet.class.newInstance();
            occ.setBranchingProcess(this);
            return occ;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public IBranchingProcess<BPN, C, E, F, N, P, T, M> clone() {
        IBranchingProcess clone = null;
        try {
            clone = (IBranchingProcess)BranchingProcess.class.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        clone.setNetSystem(this.sys);
        for (ICondition c : this.conds) {
            if (c.getPreEvent() != null) continue;
            C newC = this.createCondition(c.getPlace(), null);
            clone.appendCondition(newC);
        }
        for (IEvent e : this.log) {
            E newE = this.createEvent(e.getTransition(), null);
            ICoSet<BPN, C, ICondition, F, N, P, T, M> preset = this.createCoSet();
            HashSet max = new HashSet(clone.getMax());
            block5: for (ICondition c2 : e.getPreConditions()) {
                for (ICondition c1 : max) {
                    if (!c1.getPlace().equals(c2.getPlace())) continue;
                    preset.add(c1);
                    max.remove(c1);
                    continue block5;
                }
            }
            newE.setPreConditions(preset);
            clone.appendEvent(newE);
        }
        return clone;
    }

    @Override
    public boolean isCut(Collection<C> conditions) {
        for (ICondition c1 : conditions) {
            ArrayList<C> cs = new ArrayList<C>(conditions);
            cs.remove(c1);
            for (ICondition c2 : cs) {
                if (c1.equals(c2)) {
                    return false;
                }
                if (this.areConcurrent(c1, c2)) continue;
                return false;
            }
        }
        for (ICondition c : this.getConditions()) {
            if (conditions.contains(c)) continue;
            boolean flag = true;
            for (ICondition cc : conditions) {
                if (this.areConcurrent(c, cc)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean areMutuallyConcurrent(Collection<C> conditions) {
        for (ICondition c1 : conditions) {
            for (ICondition c2 : conditions) {
                boolean result;
                if (c1.equals(c2) || (result = this.areConcurrent(c1, c2))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<ICut<BPN, C, E, F, N, P, T, M>> getCuts(Collection<P> places) {
        HashSet<ICut<BPN, C, ICut<BPN, C, E, F, N, P, T, M>, F, N, P, T, M>> result = new HashSet<ICut<BPN, C, ICut<BPN, C, E, F, N, P, T, M>, F, N, P, T, M>>();
        ArrayList<ArrayList<C>> conds = new ArrayList<ArrayList<C>>();
        for (IPlace p : places) {
            conds.add(new ArrayList<C>(this.getConditions(p)));
        }
        ListCombinationGenerator lcg = new ListCombinationGenerator(conds);
        while (lcg.hasMoreCombinations()) {
            List cs = lcg.getNextCombination();
            if (!MultiSetUtils.isSet((Collection)cs) || !this.isCut(cs)) continue;
            ICut<BPN, C, E, F, N, P, T, M> cut = this.createCut();
            cut.addAll(cs);
            result.add(cut);
        }
        return result;
    }

    @Override
    public List<E> getLog() {
        return this.log;
    }
}

