/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.AbstractBranchingProcess;
import org.jbpt.petri.unfolding.AbstractPossibleExtensions;
import org.jbpt.petri.unfolding.CompletePrefixUnfoldingSetup;
import org.jbpt.petri.unfolding.Event;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICoSet;
import org.jbpt.petri.unfolding.ICompletePrefixUnfolding;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.ILocalConfiguration;
import org.jbpt.petri.unfolding.IOccurrenceNet;
import org.jbpt.petri.unfolding.IPossibleExtensions;
import org.jbpt.petri.unfolding.OccurrenceNet;
import org.jbpt.petri.unfolding.order.EsparzaAdequateOrderForArbitrarySystems;
import org.jbpt.petri.unfolding.order.EsparzaAdequateTotalOrderForSafeSystems;
import org.jbpt.petri.unfolding.order.IAdequateOrder;
import org.jbpt.petri.unfolding.order.McMillanAdequateOrder;
import org.jbpt.petri.unfolding.order.UnfoldingAdequateOrder;

public class AbstractCompletePrefixUnfolding<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractBranchingProcess<BPN, C, E, F, N, P, T, M>
implements ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> {
    protected CompletePrefixUnfoldingSetup setup = null;
    protected Map<E, E> cutoff2corr = new HashMap<E, E>();
    private Set<E> UPE = null;
    protected List<T> totalOrderTs = null;
    protected IAdequateOrder<BPN, C, E, F, N, P, T, M> ADEQUATE_ORDER = null;

    protected AbstractCompletePrefixUnfolding() {
    }

    public AbstractCompletePrefixUnfolding(INetSystem<F, N, P, T, M> sys) {
        this(sys, new CompletePrefixUnfoldingSetup());
    }

    public AbstractCompletePrefixUnfolding(INetSystem<F, N, P, T, M> sys, CompletePrefixUnfoldingSetup setup) {
        super(sys);
        if (this.sys == null) {
            return;
        }
        this.constructInitialBranchingProcess();
        if (this.iniBP.isEmpty()) {
            return;
        }
        this.totalOrderTs = new ArrayList(sys.getTransitions());
        this.setup = setup;
        switch (this.setup.ADEQUATE_ORDER) {
            case ESPARZA_FOR_ARBITRARY_SYSTEMS: {
                this.ADEQUATE_ORDER = new EsparzaAdequateOrderForArbitrarySystems();
                break;
            }
            case ESPARZA_FOR_SAFE_SYSTEMS: {
                this.ADEQUATE_ORDER = new EsparzaAdequateTotalOrderForSafeSystems();
                break;
            }
            case MCMILLAN: {
                this.ADEQUATE_ORDER = new McMillanAdequateOrder();
                break;
            }
            case UNFOLDING: {
                this.ADEQUATE_ORDER = new UnfoldingAdequateOrder();
                break;
            }
            default: {
                this.ADEQUATE_ORDER = new EsparzaAdequateTotalOrderForSafeSystems();
            }
        }
        if (this.setup.SAFE_OPTIMIZATION) {
            this.constructSafe();
        } else {
            this.constructSafe();
        }
    }

    protected void constructSafe() {
        IPossibleExtensions<BPN, C, E, F, N, P, T, M> pe = this.getInitialPossibleExtensions();
        while (!pe.isEmpty()) {
            if (this.events.size() >= this.setup.MAX_EVENTS) {
                return;
            }
            E e = pe.getMinimal();
            pe.remove(e);
            if (!this.appendEvent(e)) {
                return;
            }
            E corr = this.checkCutoffA(e);
            if (corr != null) {
                this.addCutoff(e, corr);
                continue;
            }
            pe.addAll(this.updatePossibleExtensions(e));
        }
    }

    protected IPossibleExtensions<BPN, C, E, F, N, P, T, M> getInitialPossibleExtensions() {
        AbstractPossibleExtensions result = new AbstractPossibleExtensions(this.ADEQUATE_ORDER);
        for (ITransition t : this.sys.getTransitions()) {
            ICoSet coset = this.containsPlaces(this.getInitialCut(), this.sys.getPreset(t));
            if (coset == null) continue;
            result.add(this.createEvent(t, coset));
        }
        return result;
    }

    private Set<E> updatePossibleExtensions(E e) {
        this.UPE = new HashSet();
        Object u = e.getTransition();
        HashSet upp = new HashSet(this.sys.getPostsetTransitions(this.sys.getPostset(u)));
        HashSet pu = new HashSet(this.sys.getPreset(u));
        pu.removeAll(this.sys.getPostset(u));
        upp.removeAll(this.sys.getPostsetTransitions(pu));
        for (ITransition t : upp) {
            ICoSet preset = this.createCoSet();
            for (ICondition b : e.getPostConditions()) {
                if (!this.sys.getPreset(t).contains(b.getPlace())) continue;
                preset.add(b);
            }
            Set<C> C = this.getConcurrentConditions(e);
            this.cover(C, t, preset);
        }
        return this.UPE;
    }

    private void cover(Set<C> CC, T t, ICoSet<BPN, C, E, F, N, P, T, M> preset) {
        if (this.sys.getPreset(t).size() == preset.size()) {
            this.UPE.add(this.createEvent(t, preset));
        } else {
            HashSet<T> pre = new HashSet<T>(this.sys.getPreset(t));
            pre.removeAll(this.getPlaces(preset));
            IPlace p = (IPlace)pre.iterator().next();
            for (ICondition d : CC) {
                if (!d.getPlace().equals(p)) continue;
                HashSet<ICondition> C2 = new HashSet<ICondition>();
                for (ICondition dd : CC) {
                    if (!this.areConcurrent(d, dd)) continue;
                    C2.add(dd);
                }
                ICoSet preset2 = this.createCoSet();
                preset2.addAll(preset);
                preset2.add(d);
                this.cover(C2, t, preset2);
            }
        }
    }

    private Set<P> getPlaces(ICoSet<BPN, C, E, F, N, P, T, M> coset) {
        HashSet result = new HashSet();
        for (ICondition c : coset) {
            result.add(c.getPlace());
        }
        return result;
    }

    private Set<C> getConcurrentConditions(E e) {
        HashSet<ICondition> result = new HashSet<ICondition>();
        for (ICondition c : this.getConditions()) {
            if (!this.areConcurrent(e, c)) continue;
            result.add(c);
        }
        return result;
    }

    protected ICoSet<BPN, C, E, F, N, P, T, M> containsPlaces(ICoSet<BPN, C, E, F, N, P, T, M> coset, Collection<P> places) {
        ICoSet result = this.createCoSet();
        for (IPlace p : places) {
            boolean flag = false;
            for (ICondition c : coset) {
                if (!c.getPlace().equals(p)) continue;
                flag = true;
                result.add(c);
                break;
            }
            if (flag) continue;
            return null;
        }
        return result;
    }

    protected E checkCutoffA(E cutoff) {
        ILocalConfiguration lce = cutoff.getLocalConfiguration();
        for (IEvent f : this.getEvents()) {
            if (f.equals(cutoff)) continue;
            ILocalConfiguration lcf = f.getLocalConfiguration();
            if (!lce.getMarking().equals(lcf.getMarking()) || !this.ADEQUATE_ORDER.isSmaller(lcf, lce)) continue;
            return (E)this.checkCutoffB(cutoff, f);
        }
        return null;
    }

    protected E checkCutoffB(E cutoff, E corr) {
        return corr;
    }

    protected void addCutoff(E e, E corr) {
        this.cutoff2corr.put(e, corr);
    }

    @Override
    public Set<E> getCutoffEvents() {
        return this.cutoff2corr.keySet();
    }

    @Override
    public boolean isCutoffEvent(E event) {
        return this.cutoff2corr.containsKey(event);
    }

    @Override
    public E getCorrespondingEvent(E event) {
        return (E)((IEvent)this.cutoff2corr.get(event));
    }

    @Override
    public List<T> getTotalOrderOfTransitions() {
        return this.totalOrderTs;
    }

    @Override
    public IOccurrenceNet<BPN, C, E, F, N, P, T, M> getOccurrenceNet() {
        try {
            IOccurrenceNet occ = (IOccurrenceNet)OccurrenceNet.class.newInstance();
            occ.setCompletePrefixUnfolding(this);
            return occ;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public E createEvent(T transition, ICoSet<BPN, C, E, F, N, P, T, M> preConditions) {
        IEvent e = null;
        try {
            e = (IEvent)Event.class.newInstance();
            e.setTransition(transition);
            e.setPreConditions(preConditions);
            e.setCompletePrefixUnfolding(this);
            return (E)e;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
            return (E)e;
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
            return (E)e;
        }
    }

    @Override
    public boolean isHealthyCutoffEvent(E event) {
        E corr = this.getCorrespondingEvent(event);
        if (corr == null) {
            return false;
        }
        HashSet ecs = new HashSet(event.getLocalConfiguration().getCut());
        HashSet ccs = new HashSet(corr.getLocalConfiguration().getCut());
        ecs.removeAll(event.getPostConditions());
        ccs.removeAll(corr.getPostConditions());
        return ecs.equals(ccs);
    }

    @Override
    public boolean isProper() {
        for (IEvent e : this.getEvents()) {
            IEvent corr = this.getCorrespondingEvent(e);
            if (corr == null || this.isHealthyCutoffEvent(e)) continue;
            return false;
        }
        return true;
    }
}

