/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.AbstractBPNode;
import org.jbpt.petri.unfolding.AbstractLocalConfiguration;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICoSet;
import org.jbpt.petri.unfolding.ICompletePrefixUnfolding;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.ILocalConfiguration;

public abstract class AbstractEvent<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractBPNode<N>
implements IEvent<BPN, C, E, F, N, P, T, M> {
    private static int count = 0;
    private T t = null;
    private ICoSet<BPN, C, E, F, N, P, T, M> pre = null;
    private ICoSet<BPN, C, E, F, N, P, T, M> post = null;
    private ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc = null;
    private ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> CPU = null;

    protected AbstractEvent() {
        this.ID = ++count;
    }

    public AbstractEvent(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu, T transition, ICoSet<BPN, C, E, F, N, P, T, M> preset) {
        this.ID = ++count;
        this.CPU = cpu;
        this.t = transition;
        this.pre = preset;
    }

    @Override
    public ICoSet<BPN, C, E, F, N, P, T, M> getPostConditions() {
        return this.post;
    }

    @Override
    public T getTransition() {
        return this.t;
    }

    @Override
    public ICoSet<BPN, C, E, F, N, P, T, M> getPreConditions() {
        return this.pre;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return String.format("%s-%s-%s", this.ID, this.t.getName(), this.t.getLabel());
    }

    public boolean equals(Object that) {
        if (that == null || !(that instanceof IEvent)) {
            return false;
        }
        if (this == that) {
            return true;
        }
        IEvent thatE = (IEvent)that;
        return this.getTransition().equals(thatE.getTransition()) && this.getPreConditions().equals(thatE.getPreConditions());
    }

    public int hashCode() {
        int hashCode = 7 * this.getTransition().hashCode();
        for (ICondition c : this.getPreConditions()) {
            hashCode += 11 * c.getPlace().hashCode();
        }
        return hashCode;
    }

    @Override
    public N getPetriNetNode() {
        return (N)this.t;
    }

    @Override
    public boolean isEvent() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public void setTransition(T transition) {
        this.t = transition;
    }

    @Override
    public void setPreConditions(ICoSet<BPN, C, E, F, N, P, T, M> preConditions) {
        this.pre = preConditions;
    }

    @Override
    public void setPostConditions(ICoSet<BPN, C, E, F, N, P, T, M> postConditions) {
        this.post = postConditions;
    }

    @Override
    public ILocalConfiguration<BPN, C, E, F, N, P, T, M> getLocalConfiguration() {
        if (this.lc != null) {
            return this.lc;
        }
        ILocalConfiguration lc = null;
        try {
            lc = (ILocalConfiguration)AbstractLocalConfiguration.class.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        lc.setEvent(this);
        lc.setCompletePrefixUnfolding(this.CPU);
        lc.construct();
        this.lc = lc;
        return this.lc;
    }

    @Override
    public void setCompletePrefixUnfolding(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu) {
        this.CPU = cpu;
    }
}

