/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.Marking;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICompletePrefixUnfolding;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.ICut;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.ILocalConfiguration;

public class AbstractLocalConfiguration<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends HashSet<E>
implements ILocalConfiguration<BPN, C, E, F, N, P, T, M> {
    private static final long serialVersionUID = 1L;
    private E e = null;
    private ICut<BPN, C, E, F, N, P, T, M> cut = null;
    private M marking = null;
    private List<T> vec = null;
    private List<Set<E>> foata = null;
    private ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> CPU = null;

    public AbstractLocalConfiguration() {
    }

    public AbstractLocalConfiguration(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu, E e) {
        this.setEvent(e);
        this.setCompletePrefixUnfolding(cpu);
        this.construct();
    }

    @Override
    public ICut<BPN, C, E, F, N, P, T, M> getCut() {
        if (this.cut == null) {
            this.cut = this.CPU.createCut();
            this.cut.addAll(this.CPU.getInitialCut());
            for (IEvent e : this) {
                this.cut.addAll(e.getPostConditions());
            }
            for (IEvent e : this) {
                this.cut.removeAll(e.getPreConditions());
            }
        }
        return this.cut;
    }

    @Override
    public M getMarking() {
        if (this.marking == null) {
            try {
                this.marking = (IMarking)Marking.class.newInstance();
                this.marking.setPetriNet(this.CPU.getOriginativeNetSystem());
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
            for (ICondition c : this.getCut()) {
                if (c.getPlace() == null) {
                    this.marking.put(c.getPlace(), 1);
                }
                this.marking.put(c.getPlace(), this.marking.get(c.getPlace()) + 1);
            }
        }
        return this.marking;
    }

    @Override
    public List<T> getQuasiParikhVector() {
        if (this.vec == null) {
            this.vec = new ArrayList<T>();
            for (IEvent e : this) {
                this.vec.add(e.getTransition());
            }
            Collections.sort(this.vec, new ParikhComparator(this.CPU.getTotalOrderOfTransitions()));
        }
        return this.vec;
    }

    @Override
    public List<T> getQuasiParikhVector(Collection<E> es) {
        ArrayList result = new ArrayList();
        for (IEvent e : es) {
            result.add(e.getTransition());
        }
        Collections.sort(result, new ParikhComparator(this.CPU.getTotalOrderOfTransitions()));
        return result;
    }

    @Override
    public List<Set<E>> getFoataNormalForm() {
        if (this.foata == null) {
            this.foata = new ArrayList<Set<E>>();
            ArrayList lc = new ArrayList(this);
            while (lc.size() > 0) {
                Set min = this.getMin(lc);
                this.foata.add(min);
                lc.removeAll(min);
            }
        }
        return this.foata;
    }

    private Set<E> getMin(Collection<E> lc) {
        HashSet<IEvent> result = new HashSet<IEvent>();
        for (IEvent e1 : lc) {
            boolean flag = true;
            for (IEvent e2 : lc) {
                if (!this.CPU.areCausal(e2, e1)) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            result.add(e1);
        }
        return result;
    }

    @Override
    public Integer compareTransitions(T t1, T t2) {
        int i1 = this.CPU.getTotalOrderOfTransitions().indexOf(t1);
        int i2 = this.CPU.getTotalOrderOfTransitions().indexOf(t2);
        if (i1 < 0 || i2 < 0) {
            return null;
        }
        if (i1 < i2) {
            return -1;
        }
        if (i1 > i2) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setEvent(E e) {
        this.e = e;
    }

    @Override
    public void setCompletePrefixUnfolding(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu) {
        this.CPU = cpu;
    }

    @Override
    public void construct() {
        this.add(this.e);
        for (ICondition c : this.e.getPreConditions()) {
            for (IBPNode iBPNode : this.CPU.getCausalPredecessors(c)) {
                if (!iBPNode.isEvent()) continue;
                this.add((IEvent)iBPNode);
            }
        }
    }

    class ParikhComparator
    implements Comparator<T> {
        private List<T> totalOrderTs = null;

        public ParikhComparator(List<T> totalOrderTs) {
            this.totalOrderTs = totalOrderTs;
        }

        @Override
        public int compare(T t1, T t2) {
            int i2;
            int i1 = this.totalOrderTs.indexOf(t1);
            if (i1 < (i2 = this.totalOrderTs.indexOf(t2))) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
    }
}

