/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.petri.AbstractPetriNet;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.IBranchingProcess;
import org.jbpt.petri.unfolding.ICompletePrefixUnfolding;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.ICut;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.IOccurrenceNet;
import org.jbpt.petri.unfolding.OrderingRelationType;

public abstract class AbstractOccurrenceNet<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractPetriNet<F, N, P, T>
implements IOccurrenceNet<BPN, C, E, F, N, P, T, M> {
    ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu = null;
    private Map<T, E> t2e = new HashMap<T, E>();
    private Map<P, C> p2c = new HashMap<P, C>();
    private Map<E, T> e2t = new HashMap<E, T>();
    private Map<C, P> c2p = new HashMap<C, P>();

    @Override
    public F addFlow(N from, N to) {
        return null;
    }

    @Override
    public Set<N> getSourceNodes() {
        return null;
    }

    @Override
    public Set<N> getSinkNodes() {
        return null;
    }

    @Override
    public Collection<P> getPlaces(Collection<C> conditions) {
        ArrayList<IPlace> result = new ArrayList<IPlace>();
        for (ICondition c : conditions) {
            result.add((IPlace)this.c2p.get(c));
        }
        return result;
    }

    @Override
    public Collection<T> getTransitions(Collection<E> events) {
        ArrayList<ITransition> result = new ArrayList<ITransition>();
        for (IEvent e : events) {
            result.add((ITransition)this.e2t.get(e));
        }
        return result;
    }

    protected AbstractOccurrenceNet() {
    }

    protected AbstractOccurrenceNet(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu) {
        this.setCompletePrefixUnfolding(cpu);
    }

    @Override
    public void setCompletePrefixUnfolding(ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> cpu) {
        this.cpu = cpu;
        this.clear();
        this.construct(this.cpu);
    }

    @Override
    public void setBranchingProcess(IBranchingProcess<BPN, C, E, F, N, P, T, M> bp) {
        this.clear();
        this.construct(bp);
    }

    private void construct(IBranchingProcess<BPN, C, E, F, N, P, T, M> bp) {
        for (IEvent e : bp.getEvents()) {
            Object t = this.createTransition();
            t.setLabel(e.getName());
            this.addTransition(t);
            this.e2t.put(e, t);
            this.t2e.put(t, e);
        }
        for (ICondition c : bp.getConditions()) {
            Object p = this.createPlace();
            p.setLabel(c.getName());
            this.addPlace(p);
            this.c2p.put(c, p);
            this.p2c.put(p, c);
        }
        for (IEvent e : bp.getEvents()) {
            for (ICondition c : e.getPreConditions()) {
                this.addFlow((N)((IPlace)this.c2p.get(c)), (N)((ITransition)this.e2t.get(e)));
            }
        }
        for (ICondition c : bp.getConditions()) {
            this.addFlow((N)((ITransition)this.e2t.get(c.getPreEvent())), (N)((IPlace)this.c2p.get(c)));
        }
    }

    @Override
    public ICompletePrefixUnfolding<BPN, C, E, F, N, P, T, M> getCompletePrefixUnfolding() {
        return this.cpu;
    }

    @Override
    public E getEvent(T t) {
        return (E)((IEvent)this.t2e.get(t));
    }

    @Override
    public C getCondition(P p) {
        return (C)((ICondition)this.p2c.get(p));
    }

    @Override
    public P getPlace(C c) {
        return (P)((IPlace)this.c2p.get(c));
    }

    @Override
    public T getTransition(E e) {
        return (T)((ITransition)this.e2t.get(e));
    }

    @Override
    public BPN getUnfoldingNode(N n) {
        if (n instanceof IPlace) {
            return (BPN)this.getCondition((IPlace)n);
        }
        if (n instanceof ITransition) {
            return (BPN)this.getEvent((ITransition)n);
        }
        return null;
    }

    @Override
    public OrderingRelationType getOrderingRelation(N n1, N n2) {
        BPN bpn1 = this.getUnfoldingNode(n1);
        BPN bpn2 = this.getUnfoldingNode(n2);
        if (bpn1 != null && bpn2 != null) {
            return this.cpu.getOrderingRelation(bpn1, bpn2);
        }
        return OrderingRelationType.UNDEFINED;
    }

    @Override
    public Set<T> getCutoffEvents() {
        HashSet<ITransition> result = new HashSet<ITransition>();
        if (this.cpu == null) {
            return result;
        }
        for (IEvent e : this.cpu.getCutoffEvents()) {
            result.add((ITransition)this.e2t.get(e));
        }
        return result;
    }

    @Override
    public T getCorrespondingEvent(T t) {
        return (T)((ITransition)this.e2t.get(this.cpu.getCorrespondingEvent((IEvent)this.t2e.get(t))));
    }

    @Override
    public boolean isCutoffEvent(T t) {
        if (this.cpu == null) {
            return false;
        }
        return this.cpu.isCutoffEvent((IEvent)this.t2e.get(t));
    }

    @Override
    public String toDOT() {
        return this.toDOT(new ArrayList(), new ArrayList());
    }

    @Override
    public String toDOT(Collection<P> places, Collection<T> transitions) {
        if (places == null) {
            return "";
        }
        if (transitions == null) {
            return "";
        }
        String result = "digraph G { label=\"" + this.getName() + "\";\n";
        result = String.valueOf(result) + "graph [fontname=\"Helvetica\" fontsize=\"10\" nodesep=\"0.35\" ranksep=\"0.25 equally\"];\n";
        result = String.valueOf(result) + "node [fontname=\"Helvetica\" fontsize=\"10\" fixedsize=\"true\" style=\"filled\" penwidth=\"2\"];\n";
        result = String.valueOf(result) + "edge [fontname=\"Helvetica\" fontsize=\"10\" arrowhead=\"normal\" color=\"black\"];\n";
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=\"circle\"];\n";
        for (IPlace p : this.getPlaces()) {
            result = places.contains(p) ? String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".5\" fillcolor=red];\n", p.getId().replace("-", ""), p.getLabel()) : String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".5\" fillcolor=white];\n", p.getId().replace("-", ""), p.getLabel());
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "node [shape=\"box\"];\n";
        for (ITransition t : this.getTransitions()) {
            if (this.isCutoffEvent(t)) {
                if (t.getLabel() == "") {
                    result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".1\" fillcolor=orange];\n", t.getId().replace("-", ""), t.getLabel());
                    continue;
                }
                result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".5\" fillcolor=orange];\n", t.getId().replace("-", ""), t.getLabel());
                continue;
            }
            if (transitions.contains(t)) {
                if (t.getLabel() == "") {
                    result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".1\" fillcolor=\"#9ACD32\"];\n", t.getId().replace("-", ""), t.getLabel());
                    continue;
                }
                result = String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".5\" fillcolor=green];\n", t.getId().replace("-", ""), t.getLabel());
                continue;
            }
            result = t.getLabel() == "" ? String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".1\" fillcolor=white];\n", t.getId().replace("-", ""), t.getLabel()) : String.valueOf(result) + String.format("\tn%s[label=\"%s\" width=\".5\" height=\".5\" fillcolor=white];\n", t.getId().replace("-", ""), t.getLabel());
        }
        result = String.valueOf(result) + "\n";
        for (IFlow f : this.getFlow()) {
            result = String.valueOf(result) + String.format("\tn%s->n%s;\n", ((INode)f.getSource()).getId().replace("-", ""), ((INode)f.getTarget()).getId().replace("-", ""));
        }
        if (this.getCutoffEvents().size() > 0) {
            result = String.valueOf(result) + "\n";
            result = String.valueOf(result) + "edge [fontname=\"Helvetica\" fontsize=\"8\" arrowhead=\"normal\" color=\"orange\"];\n";
            for (ITransition t : this.getCutoffEvents()) {
                result = String.valueOf(result) + String.format("\tn%s->n%s;\n", t.getId().replace("-", ""), this.getCorrespondingEvent(t).getId().replace("-", ""));
            }
        }
        result = String.valueOf(result) + "}\n";
        return result;
    }

    @Override
    public Set<P> getCutInducedByLocalConfiguration(T t) {
        HashSet<P> result = new HashSet<P>();
        E e = this.getEvent(t);
        ICut cut = e.getLocalConfiguration().getCut();
        for (ICondition c : cut) {
            result.add(this.getPlace(c));
        }
        return result;
    }
}

