/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding;

import java.util.HashSet;
import java.util.Set;
import org.jbpt.algo.graph.TransitiveClosure;
import org.jbpt.graph.abs.AbstractDirectedGraph;
import org.jbpt.graph.abs.IDirectedEdge;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.IBranchingProcess;
import org.jbpt.petri.unfolding.ICompletePrefixUnfolding;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.IOccurrenceNet;
import org.jbpt.petri.unfolding.IOrderingRelationsDescriptor;
import org.jbpt.petri.unfolding.IOrderingRelationsGraph;
import org.jbpt.petri.unfolding.OrderingRelationType;

public abstract class AbstractOrderingRelationsGraph<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractDirectedGraph<IDirectedEdge<E>, E>
implements IOrderingRelationsDescriptor<E, N>,
IOrderingRelationsGraph<BPN, C, E, F, N, P, T, M> {
    IBranchingProcess<BPN, C, E, F, N, P, T, M> bp = null;

    protected AbstractOrderingRelationsGraph() {
    }

    public AbstractOrderingRelationsGraph(IBranchingProcess<BPN, C, E, F, N, P, T, M> bp) {
        if (bp == null) {
            return;
        }
        this.bp = bp;
        this.construct();
    }

    private void construct() {
        IOccurrenceNet occNet = this.bp.getOccurrenceNet();
        if (this.bp instanceof ICompletePrefixUnfolding) {
            ICompletePrefixUnfolding cpu = (ICompletePrefixUnfolding)this.bp;
            for (ITransition t : occNet.getTransitions()) {
                if (!cpu.isHealthyCutoffEvent(occNet.getEvent(t))) continue;
                ITransition corr = occNet.getCorrespondingEvent(t);
                for (ITransition tt : occNet.getPostsetTransitions(occNet.getPostset(corr))) {
                    Object p = occNet.createPlace();
                    occNet.addFlow(t, (ITransition)p);
                    occNet.addFlow(p, tt);
                }
            }
        }
        TransitiveClosure tc = new TransitiveClosure(occNet);
        for (IEvent e1 : this.bp.getEvents()) {
            if (e1.getTransition().isSilent()) continue;
            for (IEvent e2 : this.bp.getEvents()) {
                T t2;
                if (e1.equals(e2) || e2.getTransition().isSilent()) continue;
                T t1 = occNet.getTransition(e1);
                if (tc.hasPath(t1, t2 = occNet.getTransition(e2))) {
                    this.addEdge(e1, e2);
                    continue;
                }
                if (!this.bp.areInConflict(e1, e2) || tc.hasPath(t2, t1)) continue;
                this.addEdge(e1, e2);
                this.addEdge(e2, e1);
            }
        }
    }

    @Override
    public OrderingRelationType getOrderingRelation(E n1, E n2) {
        if (this.getDirectedEdge((IVertex)n1, (IVertex)n2) != null) {
            if (this.getDirectedEdge((IVertex)n2, (IVertex)n1) != null) {
                return OrderingRelationType.CONFLICT;
            }
            return OrderingRelationType.CAUSAL;
        }
        if (this.getDirectedEdge((IVertex)n2, (IVertex)n1) != null) {
            return OrderingRelationType.INVERSE_CAUSAL;
        }
        return OrderingRelationType.CONCURRENT;
    }

    @Override
    public boolean areCausal(E n1, E n2) {
        return this.getDirectedEdge((IVertex)n1, (IVertex)n2) != null && this.getDirectedEdge((IVertex)n2, (IVertex)n1) == null;
    }

    @Override
    public boolean areInverseCausal(E n1, E n2) {
        return this.getDirectedEdge((IVertex)n1, (IVertex)n2) == null && this.getDirectedEdge((IVertex)n2, (IVertex)n1) != null;
    }

    @Override
    public boolean areConcurrent(E n1, E n2) {
        return this.getDirectedEdge((IVertex)n1, (IVertex)n2) == null && this.getDirectedEdge((IVertex)n2, (IVertex)n1) == null;
    }

    @Override
    public boolean areInConflict(E n1, E n2) {
        return this.getDirectedEdge((IVertex)n1, (IVertex)n2) != null && this.getDirectedEdge((IVertex)n2, (IVertex)n1) != null;
    }

    @Override
    public Set<E> getEvents() {
        return new HashSet(this.getVertices());
    }
}

