/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.unfolding.order;

import java.util.List;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.unfolding.ILocalConfiguration;
import org.jbpt.petri.unfolding.order.AdequateOrder;

public class EsparzaAdequateTotalOrderForSafeSystems<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AdequateOrder<BPN, C, E, F, N, P, T, M> {
    @Override
    public boolean isSmaller(ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc1, ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc2) {
        if (lc1.size() < lc2.size()) {
            return true;
        }
        int comp = this.compareQuasiParikhVectors(lc1, lc2);
        if (lc1.size() == lc2.size() && comp < 0) {
            return true;
        }
        int comp2 = this.compareFoataNormalForms(lc1, lc2);
        return comp == 0 && comp2 < 0;
    }

    private int compareFoataNormalForms(ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc1, ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc2) {
        List<Set<E>> foata1 = lc1.getFoataNormalForm();
        List<Set<E>> foata2 = lc2.getFoataNormalForm();
        int i = 0;
        while (i < foata1.size()) {
            List<T> pvec2;
            List<T> pvec1;
            int comp;
            boolean flag = true;
            int j = 0;
            while (j < i) {
                List<T> pvec22;
                List<T> pvec12 = lc1.getQuasiParikhVector(foata1.get(j));
                int comp2 = this.compareQuasiParikhVectors(lc1, pvec12, pvec22 = lc2.getQuasiParikhVector(foata2.get(j)));
                if (comp2 != 0) {
                    flag = false;
                    break;
                }
                ++j;
            }
            if (flag && (comp = this.compareQuasiParikhVectors(lc1, pvec1 = lc1.getQuasiParikhVector(foata1.get(i)), pvec2 = lc2.getQuasiParikhVector(foata2.get(i)))) == 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int compareQuasiParikhVectors(ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc, List<T> pvec1, List<T> pvec2) {
        int n = pvec1.size();
        if (pvec2.size() < n) {
            n = pvec2.size();
        }
        int i = 0;
        while (i < n) {
            Integer comp = lc.compareTransitions((ITransition)pvec1.get(i), (ITransition)pvec2.get(i));
            if (comp < 0) {
                return -1;
            }
            if (comp > 0) {
                return 1;
            }
            ++i;
        }
        if (pvec1.size() == pvec2.size()) {
            return 0;
        }
        if (pvec1.size() < pvec2.size()) {
            return -1;
        }
        return 1;
    }

    private int compareQuasiParikhVectors(ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc1, ILocalConfiguration<BPN, C, E, F, N, P, T, M> lc2) {
        List<T> pvec1 = lc1.getQuasiParikhVector();
        List<T> pvec2 = lc2.getQuasiParikhVector();
        return this.compareQuasiParikhVectors(lc1, pvec1, pvec2);
    }

    @Override
    public boolean isTotal() {
        return true;
    }
}

