/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.untangling;

import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jbpt.algo.graph.DirectedGraphAlgorithms;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.IRun;
import org.jbpt.petri.IStep;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.structure.PetriNetStructuralChecks;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.untangling.AbstractRepresentativeUntangling;
import org.jbpt.petri.untangling.IUntanglingRun;
import org.jbpt.petri.untangling.TreeStep;
import org.jbpt.petri.untangling.TreeStepIndex;
import org.jbpt.petri.untangling.UntanglingSetup;

public class AbstractBaselineRepresentativeUntangling<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractRepresentativeUntangling<BPN, C, E, F, N, P, T, M> {
    public AbstractBaselineRepresentativeUntangling(INetSystem<F, N, P, T, M> sys, UntanglingSetup setup) {
        super(sys, setup);
    }

    public AbstractBaselineRepresentativeUntangling(INetSystem<F, N, P, T, M> sys) {
        super(sys);
    }

    @Override
    protected void constructRuns(INetSystem<F, N, P, T, M> system) {
        switch (this.setup.SIGNIFICANCE_CHECK) {
            case EXHAUSTIVE: {
                this.constructRunsExhaustive(system);
                break;
            }
            case HASHMAP_BASED: {
                this.constructRunsHashmapBased(system);
                break;
            }
            case TREE_OF_RUNS: {
                this.constructRunsTreeOfRuns(system);
                break;
            }
            default: {
                this.constructRunsExhaustive(system);
            }
        }
    }

    private void constructRunsExhaustive(INetSystem<F, N, P, T, M> system) {
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        IRun<F, N, P, ITransition, M> ini = this.createRun(system);
        PetriNetStructuralChecks sc = new PetriNetStructuralChecks();
        DirectedGraphAlgorithms dga = new DirectedGraphAlgorithms();
        if (sc.isConflictFree(system) && dga.isAcyclic(system)) {
            Set<T> PE = ini.getPossibleExtensions();
            while (!PE.isEmpty()) {
                ini.append((ITransition)PE.iterator().next());
            }
            ++this.significantRunCounter;
            this.runs.add(ini);
            return;
        }
        queue.add(ini);
        ++this.significantRunCounter;
        while (!queue.isEmpty()) {
            Set PE;
            if (queue.size() % 1000 == 0) {
                System.out.println(queue.size());
            }
            IRun run = (IRun)queue.poll();
            if (this.safe && run.size() > 0 && !((IStep)run.get(run.size() - 1)).getOutputMarking().isSafe()) {
                this.safe = false;
            }
            if ((PE = run.getPossibleExtensions()).isEmpty()) {
                if (this.setup.REDUCE) {
                    this.prune(run);
                }
                this.runs.add(run);
                if (this.runs.size() % 1000 != 0) continue;
                System.err.println(this.runs.size());
                continue;
            }
            boolean allExtensionsInsignificant = true;
            for (ITransition t : PE) {
                IRun freshRun = run.clone();
                freshRun.append(t);
                if (!this.isSignificant(freshRun)) continue;
                queue.add(freshRun);
                ++this.significantRunCounter;
                allExtensionsInsignificant = false;
            }
            if (!allExtensionsInsignificant) continue;
            if (this.setup.REDUCE) {
                this.prune(run);
            }
            this.runs.add(run);
            if (this.runs.size() % 1000 != 0) continue;
            System.err.println(this.runs.size());
        }
        System.out.println("FINISHED WHILE LOOP");
        System.out.println(this.runs.size());
        if (this.setup.REDUCE) {
            System.err.println("REDUCING PROCESSES");
            this.reduceSubruns();
        }
    }

    private void constructRunsHashmapBased(INetSystem<F, N, P, T, M> system) {
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        IUntanglingRun<F, N, P, ITransition, M> ini = this.createUntanglingRun(system);
        PetriNetStructuralChecks sc = new PetriNetStructuralChecks();
        DirectedGraphAlgorithms dga = new DirectedGraphAlgorithms();
        if (sc.isConflictFree(system) && dga.isAcyclic(system)) {
            Set PE = ini.getPossibleExtensions();
            while (!PE.isEmpty()) {
                ini.append((ITransition)PE.iterator().next());
            }
            ++this.significantRunCounter;
            this.runs.add(ini);
            return;
        }
        queue.add(ini);
        ++this.significantRunCounter;
        while (!queue.isEmpty()) {
            IUntanglingRun run = (IUntanglingRun)queue.poll();
            if (run.size() > 0 && !((IStep)run.get(run.size() - 1)).getOutputMarking().isSafe()) {
                this.safe = false;
                return;
            }
            Set PE = run.getPossibleExtensions();
            if (PE.isEmpty()) {
                if (this.setup.REDUCE) {
                    this.prune(run);
                }
                this.runs.add(run);
                continue;
            }
            boolean allExtensionsInsignificant = true;
            for (ITransition t : PE) {
                IUntanglingRun freshRun = run.clone();
                freshRun.append(t);
                if (!freshRun.isSignificant()) continue;
                queue.add(freshRun);
                ++this.significantRunCounter;
                allExtensionsInsignificant = false;
            }
            if (!allExtensionsInsignificant) continue;
            if (this.setup.REDUCE) {
                this.prune(run);
            }
            this.runs.add(run);
        }
        if (this.setup.REDUCE) {
            this.reduceSubruns();
        }
    }

    private void constructRunsTreeOfRuns(INetSystem<F, N, P, T, M> system) {
        this.torRoot = new TreeStep(system, null, null, null, system.getMarking().clone(), 0);
        this.torRoot.index = new TreeStepIndex();
        this.torLeaves = new ArrayList();
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        PetriNetStructuralChecks sc = new PetriNetStructuralChecks();
        DirectedGraphAlgorithms dga = new DirectedGraphAlgorithms();
        if (sc.isConflictFree(system) && dga.isAcyclic(system)) {
            IRun<F, N, P, ITransition, M> ini = this.createRun(system);
            Set<T> PE = ini.getPossibleExtensions();
            while (!PE.isEmpty()) {
                ini.append((ITransition)PE.iterator().next());
            }
            ++this.significantRunCounter;
            this.runs.add(ini);
            return;
        }
        if (!this.torRoot.isSafe()) {
            this.safe = false;
            return;
        }
        queue.add(this.torRoot);
        ++this.significantRunCounter;
        while (!queue.isEmpty()) {
            TreeStep curr = (TreeStep)queue.poll();
            Set PE = curr.getPossibleExtensions();
            if (PE.isEmpty()) {
                this.torLeaves.add(curr);
                continue;
            }
            boolean allExtensionsInsignificant = true;
            for (TreeStep ext : PE) {
                if (!ext.isSignificant()) continue;
                if (!ext.isSafe()) {
                    this.safe = false;
                    return;
                }
                allExtensionsInsignificant = false;
                queue.add(ext);
                ++this.significantRunCounter;
            }
            if (!allExtensionsInsignificant) continue;
            this.torLeaves.add(curr);
        }
    }
}

