/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.untangling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.IRun;
import org.jbpt.petri.IStep;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.untangling.AbstractBaselineRepresentativeUntangling;
import org.jbpt.petri.untangling.IProcess;
import org.jbpt.petri.untangling.UntanglingSetup;

public class AbstractReductionBasedRepresentativeUntangling<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>>
extends AbstractBaselineRepresentativeUntangling<BPN, C, E, F, N, P, T, M> {
    private Map<F, List<N>> abs = null;
    private Map<N, N> map = null;
    private Map<N, N> map2 = null;

    public AbstractReductionBasedRepresentativeUntangling(INetSystem<F, N, P, T, M> sys) {
        super(sys);
    }

    public AbstractReductionBasedRepresentativeUntangling(INetSystem<F, N, P, T, M> sys, UntanglingSetup setup) {
        super(sys, setup);
    }

    @Override
    protected void constructRuns(INetSystem<F, N, P, T, M> system) {
        this.map2 = new HashMap<N, N>();
        this.reducedSys = system.clone(this.map2);
        this.map = new HashMap<N, N>();
        for (Map.Entry<N, N> entry : this.map2.entrySet()) {
            this.map.put((INode)entry.getValue(), (INode)entry.getKey());
        }
        try {
            this.abs = this.reduce(this.reducedSys);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        super.constructRuns(this.reducedSys);
    }

    @Override
    protected void constructProcesses() {
        IProcess pi;
        this.reducedProcesses = new ArrayList();
        for (IRun run : this.runs) {
            pi = this.createProcess(this.reducedSys);
            for (IStep step : run) {
                pi.appendTransition(step.getTransition());
            }
            this.reducedProcesses.add(pi);
        }
        this.processes = new ArrayList();
        for (IRun run : this.runs) {
            int i;
            List<IPlace> list;
            pi = this.createProcess(this.sys);
            for (IStep step : run) {
                for (IPlace p : step.getInputMarking().toMultiSet()) {
                    list = this.getAbstractedNodes(p, step.getTransition());
                    if (list == null) continue;
                    i = 0;
                    while (i < list.size()) {
                        pi.appendTransition((ITransition)this.map.get(list.get(i)));
                        i += 2;
                    }
                }
                pi.appendTransition((ITransition)this.map.get(step.getTransition()));
                for (IPlace p : step.getOutputMarking().toMultiSet()) {
                    list = this.getAbstractedNodes(step.getTransition(), p);
                    if (list == null) continue;
                    i = 1;
                    while (i < list.size()) {
                        pi.appendTransition((ITransition)this.map.get(list.get(i)));
                        i += 2;
                    }
                }
            }
            for (ICondition c : pi.getMax()) {
                for (IFlow f : this.reducedSys.getOutgoingEdges((INode)this.map2.get(c.getPlace()))) {
                    if (!this.abs.containsKey(f)) continue;
                    list = this.abs.get(f);
                    i = 0;
                    while (i < list.size()) {
                        pi.appendTransition((ITransition)this.map.get(list.get(i)));
                        i += 2;
                    }
                }
            }
            this.processes.add(pi);
        }
    }

    private List<N> getAbstractedNodes(N n1, N n2) {
        for (Map.Entry<F, List<N>> entry : this.abs.entrySet()) {
            IFlow f = (IFlow)entry.getKey();
            if (!((INode)f.getSource()).equals(n1) || !((INode)f.getTarget()).equals(n2)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected Map<F, List<N>> reduce(INetSystem<F, N, P, T, M> system) {
        HashMap result = new HashMap();
        ArrayList maxSequences = new ArrayList();
        HashSet flow = new HashSet(system.getFlow());
        ArrayList<IFlow> seq = new ArrayList<IFlow>();
        boolean flag = false;
        INode entry = null;
        INode exit = null;
        while (!flow.isEmpty()) {
            boolean bl;
            IFlow nf;
            if (!flag) {
                IFlow iFlow = (IFlow)flow.iterator().next();
                flow.remove(iFlow);
                seq.add(iFlow);
                entry = (INode)iFlow.getSource();
                exit = (INode)iFlow.getTarget();
                flag = true;
                continue;
            }
            boolean bl2 = true;
            IPlace p = null;
            if (entry instanceof IPlace) {
                p = (IPlace)entry;
            }
            if (system.getDirectPredecessors(entry).size() == 1 && system.getDirectSuccessors(entry).size() == 1 && (p == null || system.getTokens((ITransition)((Object)p)) == 0)) {
                nf = (IFlow)system.getFirstIncomingEdge(entry);
                seq.add(0, nf);
                entry = (INode)nf.getSource();
                boolean bl3 = false;
                flow.remove(nf);
            }
            p = null;
            if (exit instanceof IPlace) {
                p = (IPlace)exit;
            }
            if (system.getDirectPredecessors(exit).size() == 1 && system.getDirectSuccessors(exit).size() == 1 && (p == null || system.getTokens((ITransition)((Object)p)) == 0)) {
                nf = (IFlow)system.getFirstOutgoingEdge(exit);
                seq.add(nf);
                exit = (INode)nf.getTarget();
                bl = false;
                flow.remove(nf);
            }
            if (!bl) continue;
            flag = false;
            maxSequences.add(new ArrayList(seq));
            seq = new ArrayList();
            entry = null;
            exit = null;
        }
        maxSequences.add(seq);
        for (List list : maxSequences) {
            Object f;
            INode ex;
            INode last;
            List<N> list2;
            INode en;
            if (list.size() < 3) continue;
            INode start = (INode)((IFlow)list.get(0)).getSource();
            INode end = (INode)((IFlow)list.get(list.size() - 1)).getTarget();
            if (start instanceof IPlace) {
                boolean safe;
                if (end instanceof IPlace) {
                    en = (IPlace)start;
                    list2 = this.getOrderedNodes(list);
                    last = (ITransition)list2.get(list2.size() - 1);
                    list2.remove(list2.size() - 1);
                    system.removeNodes(list2);
                    Object f2 = system.addFlow((IPlace)en, (ITransition)last);
                    result.put(f2, list2);
                    continue;
                }
                en = (IPlace)start;
                ex = (ITransition)end;
                f = null;
                boolean bl = safe = system.getPostset((IPlace)en).size() == 1 || system.getPreset((IPlace)ex).size() == 1;
                if (safe && (f = (Object)system.addFlow((IPlace)en, (ITransition)ex)) != null) {
                    List<N> list22 = this.getOrderedNodes(list);
                    system.removeNodes(list22);
                    result.put(f, list22);
                }
                if (safe || f != null || list.size() < 5) continue;
                List<N> list3 = this.getOrderedNodes(list);
                ITransition last2 = (ITransition)list3.get(list3.size() - 2);
                list3.remove(list3.size() - 1);
                list3.remove(list3.size() - 1);
                system.removeNodes(list3);
                f = system.addFlow((IPlace)en, last2);
                result.put(f, list3);
                continue;
            }
            if (end instanceof IPlace) {
                en = (ITransition)start;
                ex = (IPlace)end;
                f = system.addFlow((IPlace)en, (ITransition)ex);
                if (f == null) {
                    if (list.size() < 5) continue;
                    List<N> list4 = this.getOrderedNodes(list);
                    IPlace last3 = (IPlace)list4.get(list4.size() - 2);
                    list4.remove(list4.size() - 1);
                    list4.remove(list4.size() - 1);
                    system.removeNodes(list4);
                    f = system.addFlow((IPlace)en, (ITransition)((Object)last3));
                    result.put(f, list4);
                    continue;
                }
                List<N> list3 = this.getOrderedNodes(list);
                system.removeNodes(list3);
                result.put(f, list3);
                continue;
            }
            en = (ITransition)start;
            list2 = this.getOrderedNodes(list);
            last = (IPlace)list2.get(list2.size() - 1);
            list2.remove(list2.size() - 1);
            system.removeNodes(list2);
            Object f2 = system.addFlow((IPlace)en, (ITransition)last);
            result.put(f2, list2);
        }
        return result;
    }

    private List<N> getOrderedNodes(List<F> polygon) {
        ArrayList<INode> result = new ArrayList<INode>();
        int i = 1;
        while (i < polygon.size()) {
            result.add((INode)((IFlow)polygon.get(i)).getSource());
            ++i;
        }
        return result;
    }

    @Override
    public boolean isNonSinkDeadlockFree() {
        for (IRun run : this.runs) {
            if (run.isEmpty()) {
                return false;
            }
            IStep step = (IStep)run.get(run.size() - 1);
            if (!this.reducedSys.getEnabledTransitionsAtMarking(step.getOutputMarking()).isEmpty()) continue;
            for (IPlace p : step.getOutputMarking().toMultiSet()) {
                if (this.reducedSys.getPostset(p).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

