/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.untangling;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.IMarking;
import org.jbpt.petri.INetSystem;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.IRun;
import org.jbpt.petri.IStep;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.Run;
import org.jbpt.petri.unfolding.IBPNode;
import org.jbpt.petri.unfolding.ICondition;
import org.jbpt.petri.unfolding.IEvent;
import org.jbpt.petri.untangling.IProcess;
import org.jbpt.petri.untangling.IUntanglingRun;
import org.jbpt.petri.untangling.Process;
import org.jbpt.petri.untangling.SignificanceCheckType;
import org.jbpt.petri.untangling.TreeStep;
import org.jbpt.petri.untangling.UntanglingRun;
import org.jbpt.petri.untangling.UntanglingSetup;
import org.jbpt.utils.IOUtils;

public abstract class AbstractRepresentativeUntangling<BPN extends IBPNode<N>, C extends ICondition<BPN, C, E, F, N, P, T, M>, E extends IEvent<BPN, C, E, F, N, P, T, M>, F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition, M extends IMarking<F, N, P, T>> {
    protected INetSystem<F, N, P, T, M> sys = null;
    protected INetSystem<F, N, P, T, M> reducedSys = null;
    protected Set<IRun<F, N, P, T, M>> runs = null;
    protected TreeStep<F, N, P, T, M> torRoot = null;
    protected List<TreeStep<F, N, P, T, M>> torLeaves = null;
    protected Collection<IProcess<BPN, C, E, F, N, P, T, M>> processes = null;
    protected Collection<IProcess<BPN, C, E, F, N, P, T, M>> reducedProcesses = null;
    protected int significantRunCounter = 0;
    protected boolean safe = true;
    protected UntanglingSetup setup;
    protected long time = 0L;
    protected boolean cyclic = false;
    Set<IStep<F, N, P, T, M>> steps = new HashSet<IStep<F, N, P, T, M>>();

    public AbstractRepresentativeUntangling(INetSystem<F, N, P, T, M> sys) {
        this(sys, new UntanglingSetup());
    }

    public AbstractRepresentativeUntangling(INetSystem<F, N, P, T, M> sys, UntanglingSetup setup) {
        if (sys == null) {
            return;
        }
        this.setup = setup;
        this.sys = sys;
        this.runs = new HashSet<IRun<F, N, P, T, M>>();
        long start = System.nanoTime();
        this.constructRuns(this.sys);
        long stop = System.nanoTime();
        this.time = stop - start;
        if (this.setup.SIGNIFICANCE_CHECK == SignificanceCheckType.TREE_OF_RUNS) {
            for (TreeStep<F, N, P, T, M> step : this.torLeaves) {
                IRun<F, N, P, T, M> run = this.constructRun(step);
                this.runs.add(run);
            }
        }
        this.constructProcesses();
    }

    public Set<IRun<F, N, P, T, M>> getMaximalSignificantRuns() {
        return this.runs;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public Collection<IProcess<BPN, C, E, F, N, P, T, M>> getProcesses() {
        return this.processes;
    }

    public Collection<IProcess<BPN, C, E, F, N, P, T, M>> getReducedProcesses() {
        return this.reducedProcesses;
    }

    public INetSystem<F, N, P, T, M> getReducedNetSystem() {
        return this.reducedSys;
    }

    protected void constructProcesses() {
        this.processes = new ArrayList<IProcess<BPN, C, E, F, N, P, T, M>>();
        for (IRun<F, N, P, T, M> run : this.runs) {
            IProcess pi = this.createProcess(this.sys);
            for (IStep iStep : run) {
                pi.appendTransition(iStep.getTransition());
            }
            this.processes.add(pi);
        }
    }

    private IRun<F, N, P, T, M> constructRun(TreeStep<F, N, P, T, M> step) {
        ArrayList<TreeStep<F, N, P, T, M>> list = new ArrayList<TreeStep<F, N, P, T, M>>();
        TreeStep<F, N, P, T, M> s = step;
        list.add(s);
        while (s.getParent() != null) {
            s = s.getParent();
            list.add(0, s);
        }
        INetSystem<F, N, P, T, M> netSystem = this.reducedSys == null ? this.sys : this.reducedSys;
        IRun run = this.createRun(netSystem);
        for (TreeStep treeStep : list) {
            if (treeStep.getTransition() == null) continue;
            run.append(treeStep.getTransition());
        }
        return run;
    }

    protected IProcess<BPN, C, E, F, N, P, T, M> createProcess(INetSystem<F, N, P, T, M> sys) {
        IProcess pi = null;
        try {
            pi = (IProcess)Process.class.newInstance();
            pi.setNetSystem(sys);
            pi.constructInitialBranchingProcess();
            return pi;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        return pi;
    }

    protected IRun<F, N, P, T, M> createRun(INetSystem<F, N, P, T, M> sys) {
        IRun run = null;
        try {
            run = (IRun)Run.class.newInstance();
            run.setNetSystem(sys);
            return run;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        return run;
    }

    protected IUntanglingRun<F, N, P, T, M> createUntanglingRun(INetSystem<F, N, P, T, M> sys) {
        IUntanglingRun run = null;
        try {
            run = (IUntanglingRun)UntanglingRun.class.newInstance();
            run.setNetSystem(sys);
            return run;
        }
        catch (InstantiationException exception) {
            exception.printStackTrace();
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace();
        }
        return run;
    }

    public void serializeProcesses() {
        int i = 1;
        for (IProcess<BPN, C, E, F, N, P, T, M> pi : this.getProcesses()) {
            try {
                IOUtils.invokeDOT((String)"./", (String)("p" + i++ + ".png"), (String)pi.getOccurrenceNet().toDOT());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void serializeReducedProcesses() {
        int i = 1;
        for (IProcess<BPN, C, E, F, N, P, T, M> pi : this.getReducedProcesses()) {
            try {
                IOUtils.invokeDOT((String)"./", (String)("rp" + i++ + ".png"), (String)pi.getOccurrenceNet().toDOT());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void constructRuns(INetSystem<F, N, P, T, M> system) {
    }

    protected boolean isSignificant(IRun<F, N, P, T, M> run) {
        int i = 0;
        while (i < run.size()) {
            int j = i + 1;
            while (j < run.size()) {
                if (((IStep)run.get(i)).equals(run.get(j))) {
                    boolean flag = false;
                    int k = i + 1;
                    while (k < j) {
                        boolean flagK = true;
                        int m = 0;
                        while (m < run.size()) {
                            if ((m < i || m > j) && ((IStep)run.get(k)).equals(run.get(m))) {
                                flagK = false;
                                break;
                            }
                            ++m;
                        }
                        if (flag |= flagK) break;
                        ++k;
                    }
                    if (!flag) {
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected boolean isSignificantCubic(IRun<F, N, P, T, M> run) {
        int i = 0;
        while (i < run.size()) {
            int j = i + 1;
            while (j < run.size()) {
                if (((IStep)run.get(i)).equals(run.get(j))) {
                    this.steps.clear();
                    int k = i + 1;
                    while (k < j) {
                        this.steps.add((IStep)run.get(k));
                        ++k;
                    }
                    if (this.steps.isEmpty()) {
                        return false;
                    }
                    int m = 0;
                    while (m < i) {
                        if (this.steps.remove(run.get(m)) && this.steps.isEmpty()) {
                            return false;
                        }
                        ++m;
                    }
                    m = j + 1;
                    while (m < run.size()) {
                        if (this.steps.remove(run.get(m)) && this.steps.isEmpty()) {
                            return false;
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected void prune(IRun<F, N, P, T, M> run) {
        int k = run.size() - 1;
        int i = run.size() - 1;
        while (i > 0) {
            boolean flag = false;
            int j = 0;
            while (j < i) {
                if (((IStep)run.get(i)).equals(run.get(j))) {
                    flag = true;
                    break;
                }
                ++j;
            }
            if (!flag) break;
            k = i - 1;
            --i;
        }
        int m = run.size() - 1;
        while (m > k) {
            run.remove(m);
            --m;
        }
    }

    public int getNumberOfSignificantRuns() {
        return this.significantRunCounter;
    }

    public boolean isDeadlockFree() {
        for (IRun<F, N, P, T, M> run : this.runs) {
            if (run.isEmpty()) {
                return false;
            }
            IStep step = (IStep)run.get(run.size() - 1);
            if (!this.sys.getEnabledTransitionsAtMarking(step.getOutputMarking()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isNonSinkDeadlockFree() {
        for (IRun<F, N, P, T, M> run : this.runs) {
            if (run.isEmpty()) {
                return false;
            }
            IStep step = (IStep)run.get(run.size() - 1);
            if (!this.sys.getEnabledTransitionsAtMarking(step.getOutputMarking()).isEmpty()) continue;
            for (IPlace p : step.getOutputMarking().toMultiSet()) {
                if (this.sys.getPostset(p).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    protected void reduceSubruns() {
        boolean flag = true;
        IRun<F, N, P, T, M> run = null;
        while (flag) {
            flag = false;
            for (IRun<F, N, P, T, M> run1 : this.runs) {
                for (IRun<F, N, P, T, M> run2 : this.runs) {
                    if (run1.equals(run2)) continue;
                    if (run1.containsAll(run2)) {
                        run = run2;
                        flag = true;
                        break;
                    }
                    if (!run1.containsAll(run2) || !run2.containsAll(run1) || run1.size() >= run2.size()) continue;
                    run = run2;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if (!flag) continue;
            this.runs.remove(run);
        }
    }

    public long getTime() {
        return this.time;
    }
}

