/*
 * Decompiled with CFR 0.152.
 */
package org.jbpt.petri.wftree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpt.algo.tree.rpst.IRPSTNode;
import org.jbpt.algo.tree.rpst.RPST;
import org.jbpt.algo.tree.tctree.TCType;
import org.jbpt.hypergraph.abs.IVertex;
import org.jbpt.petri.IFlow;
import org.jbpt.petri.INode;
import org.jbpt.petri.IPetriNet;
import org.jbpt.petri.IPlace;
import org.jbpt.petri.ITransition;
import org.jbpt.petri.wftree.IWFTree;
import org.jbpt.petri.wftree.WFTreeBondType;
import org.jbpt.petri.wftree.WFTreeLoopOrientationType;

public abstract class AbstractWFTree<F extends IFlow<N>, N extends INode, P extends IPlace, T extends ITransition>
extends RPST<F, N>
implements IWFTree<F, N, P, T> {
    private Map<IRPSTNode<F, N>, WFTreeBondType> bond2type = new HashMap<IRPSTNode<F, N>, WFTreeBondType>();
    private Map<IRPSTNode<F, N>, WFTreeLoopOrientationType> loop2type = new HashMap<IRPSTNode<F, N>, WFTreeLoopOrientationType>();

    public AbstractWFTree(IPetriNet<F, N, P, T> net) {
        super(net);
    }

    @Override
    public WFTreeBondType getRefinedBondType(IRPSTNode<F, N> node) {
        if (node.getType() != TCType.BOND) {
            return WFTreeBondType.UNDEFINED;
        }
        WFTreeBondType type = this.bond2type.get(node);
        if (type != null) {
            return type;
        }
        INode entry = (INode)node.getEntry();
        INode exit = (INode)node.getExit();
        if (entry == null || exit == null) {
            return WFTreeBondType.UNDEFINED;
        }
        for (IRPSTNode child : this.getChildren((IVertex)node)) {
            if (!((INode)child.getEntry()).equals(node.getExit())) continue;
            type = WFTreeBondType.LOOP;
            this.bond2type.put(node, type);
            return type;
        }
        if (entry instanceof ITransition && exit instanceof ITransition) {
            type = WFTreeBondType.TRANSITION_BORDERED;
            this.bond2type.put(node, type);
            return type;
        }
        if (entry instanceof IPlace && exit instanceof IPlace) {
            type = WFTreeBondType.PLACE_BORDERED;
            this.bond2type.put(node, type);
            return type;
        }
        return WFTreeBondType.UNDEFINED;
    }

    @Override
    public WFTreeLoopOrientationType getLoopOrientationType(IRPSTNode<F, N> node) {
        if (this.isRoot((IVertex)node)) {
            return WFTreeLoopOrientationType.UNDEFINED;
        }
        WFTreeLoopOrientationType type = this.loop2type.get(node);
        if (type != null) {
            return type;
        }
        if (this.getRefinedBondType((IRPSTNode)this.getParent((IVertex)node)) != WFTreeBondType.LOOP) {
            return WFTreeLoopOrientationType.UNDEFINED;
        }
        if (((INode)node.getEntry()).equals(((IRPSTNode)this.getParent((IVertex)node)).getEntry())) {
            type = WFTreeLoopOrientationType.FORWARD;
            this.loop2type.put(node, type);
            return type;
        }
        if (((INode)node.getEntry()).equals(((IRPSTNode)this.getParent((IVertex)node)).getExit())) {
            type = WFTreeLoopOrientationType.BACKWARD;
            this.loop2type.put(node, type);
            return type;
        }
        return WFTreeLoopOrientationType.UNDEFINED;
    }

    @Override
    public Set<IRPSTNode<F, N>> getRPSTNodes(WFTreeBondType type) {
        HashSet<IRPSTNode<F, N>> result = new HashSet<IRPSTNode<F, N>>();
        for (IRPSTNode node : this.getVertices()) {
            if (this.getRefinedBondType(node) != type) continue;
            result.add(node);
        }
        return result;
    }
}

