/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.jclouds.byon.functions.NodeToNodeMetadataTest;
import org.jclouds.byon.functions.NodesFromYamlTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BYONComputeServiceTest {
    @Test
    public void testNodesParseWithFileUrl() throws Exception {
        this.assertNodesParse("file://" + this.getClass().getResource("/test1.yaml").getPath());
    }

    @Test
    public void testNodesParseWithClasspathUrl() throws Exception {
        this.assertNodesParse("classpath:///test1.yaml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodesParse(String endpoint) {
        ComputeServiceContext context = null;
        try {
            Properties props = new Properties();
            props.setProperty("byon.endpoint", endpoint);
            context = new ComputeServiceContextFactory().createContext("byon", "foo", "bar", (Iterable)ImmutableSet.of((Object)new JschSshClientModule()), props);
            Assert.assertEquals((Object)context.getProviderSpecificContext().getEndpoint(), (Object)URI.create(endpoint));
            Supplier supplier = (Supplier)context.getProviderSpecificContext().getApi();
            Assert.assertEquals((int)((Map)supplier.get()).size(), (int)context.getComputeService().listNodes().size());
            Assert.assertEquals((Object)supplier.get(), (Object)ImmutableMap.of((Object)NodesFromYamlTest.TEST1.id, (Object)NodesFromYamlTest.TEST1));
            Assert.assertEquals((Collection)context.getComputeService().listNodes(), (Collection)ImmutableSet.of((Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(endpoint)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

