/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jclouds.byon.functions.NodeToNodeMetadata;
import org.jclouds.byon.functions.NodesFromYamlTest;
import org.jclouds.byon.suppliers.SupplyFromProviderURIOrNodesProperty;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystemBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodeToNodeMetadataTest {
    public static Location expectedLocationFromResource(String resource) {
        return new LocationBuilder().scope(LocationScope.PROVIDER).id("byon").description(resource).build();
    }

    public static NodeMetadata expectedNodeMetadataFromResource(String resource) {
        Location location = NodeToNodeMetadataTest.expectedLocationFromResource(resource);
        return new NodeMetadataBuilder().ids("cluster-1").group("hadoop").name("cluster-1").location(location).state(NodeState.RUNNING).operatingSystem(new OperatingSystemBuilder().description("redhat").family(OsFamily.RHEL).arch("x86").version("5.3").build()).publicAddresses((Iterable)ImmutableSet.of((Object)"cluster-1.mydomain.com")).credentials(new Credentials("myUser", NodesFromYamlTest.key)).adminPassword("happy bear").build();
    }

    @Test
    public void testNodesParse() throws Exception {
        LinkedHashMap credentialStore = Maps.newLinkedHashMap();
        NodeToNodeMetadata parser = new NodeToNodeMetadata(Suppliers.ofInstance((Object)NodeToNodeMetadataTest.expectedLocationFromResource("location")), (Function)new SupplyFromProviderURIOrNodesProperty(URI.create("test")), (Map)credentialStore);
        Assert.assertEquals((Object)parser.apply(NodesFromYamlTest.TEST1), (Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource("location"));
        Assert.assertEquals((Object)credentialStore, (Object)ImmutableMap.of((Object)"node#cluster-1", (Object)new Credentials("myUser", NodesFromYamlTest.key)));
    }
}

