/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystemBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

@Singleton
public class NodeToNodeMetadata
implements Function<Node, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<Location> location;
    private final Map<String, Credentials> credentialStore;
    private final Function<URI, InputStream> slurp;

    @Inject
    NodeToNodeMetadata(Supplier<Location> location, Function<URI, InputStream> slurp, Map<String, Credentials> credentialStore) {
        this.location = (Supplier)Preconditions.checkNotNull(location, (Object)"location");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.slurp = (Function)Preconditions.checkNotNull(slurp, (Object)"slurp");
    }

    public NodeMetadata apply(Node from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId());
        builder.name(from.getName());
        builder.location((Location)this.location.get());
        builder.group(from.getGroup());
        builder.operatingSystem(new OperatingSystemBuilder().arch(from.getOsArch()).family(OsFamily.fromValue((String)from.getOsFamily())).description(from.getOsDescription()).version(from.getOsVersion()).build());
        builder.state(NodeState.RUNNING);
        builder.publicAddresses((Iterable)ImmutableSet.of((Object)from.getHostname()));
        if (from.getUsername() != null) {
            Credentials creds = null;
            if (from.getCredentialUrl() != null) {
                try {
                    creds = new Credentials(from.getUsername(), Strings2.toStringAndClose((InputStream)((InputStream)this.slurp.apply((Object)from.getCredentialUrl()))));
                }
                catch (IOException e) {
                    this.logger.error((Throwable)e, "URI could not be read: %s", new Object[]{from.getCredentialUrl()});
                }
            } else if (from.getCredential() != null) {
                creds = new Credentials(from.getUsername(), from.getCredential());
            }
            if (creds != null) {
                builder.credentials(creds);
            }
            this.credentialStore.put("node#" + from.getId(), creds);
        }
        if (from.getSudoPassword() != null) {
            builder.adminPassword(from.getSudoPassword());
        }
        return builder.build();
    }
}

