/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jclouds.byon.Node;
import org.jclouds.byon.functions.NodesFromYaml;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodesFromYamlTest {
    public static final String key = "-----BEGIN RSA PRIVATE KEY-----\n" + "MIIEowIBAAKCAQEAuzaE6azgUxwESX1rCGdJ5xpdrc1XC311bOGZBCE8NA+CpFh2\n" + "u01Vfv68NC4u6LFgdXSY1vQt6hiA5TNqQk0TyVfFAunbXgTekF6XqDPQUf1nq9aZ\n" + "lMvo4vlaLDKBkhG5HJE/pIa0iB+RMZLS0GhxsIWerEDmYdHKM25o\n" + "-----END RSA PRIVATE KEY-----\n";
    public static final Node TEST1 = new Node("cluster-1", "cluster-1", "accounting analytics cluster", "cluster-1.mydomain.com", "x86", "rhel", "redhat", "5.3", "hadoop", (List)ImmutableList.of((Object)"vanilla"), "myUser", key, null, "happy bear");

    @Test
    public void testNodesParse() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/test1.yaml");
        NodesFromYaml parser = new NodesFromYaml();
        Assert.assertEquals((Map)parser.apply(is), (Map)ImmutableMap.of((Object)TEST1.getId(), (Object)TEST1));
    }

    @Test
    public void testNodesParseWhenCredentialInUrl() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/test_with_url.yaml");
        NodesFromYaml parser = new NodesFromYaml();
        Assert.assertEquals((Map)parser.apply(is), (Map)ImmutableMap.of((Object)TEST1.getId(), (Object)TEST1));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testMustParseSomething() throws Exception {
        new NodesFromYaml().apply(Strings2.toInputStream((String)""));
    }
}

