/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.functions.NodeToNodeMetadata;
import org.jclouds.compute.JCloudsNativeComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.location.suppliers.JustProvider;

@Singleton
public class BYONComputeServiceAdapter
implements JCloudsNativeComputeServiceAdapter {
    private final Supplier<Map<String, Node>> nodes;
    private final NodeToNodeMetadata converter;
    private final JustProvider locationSupplier;

    @Inject
    public BYONComputeServiceAdapter(Supplier<Map<String, Node>> nodes, NodeToNodeMetadata converter, JustProvider locationSupplier) {
        this.nodes = (Supplier)Preconditions.checkNotNull(nodes, (Object)"nodes");
        this.converter = (NodeToNodeMetadata)Preconditions.checkNotNull((Object)converter, (Object)"converter");
        this.locationSupplier = (JustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationSupplier");
    }

    public NodeMetadata createNodeWithGroupEncodedIntoNameThenStoreCredentials(String tag, String name, Template template, Map<String, Credentials> credentialStore) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Hardware> listHardwareProfiles() {
        return ImmutableSet.of();
    }

    public Iterable<Image> listImages() {
        return ImmutableSet.of();
    }

    public Iterable<NodeMetadata> listNodes() {
        return Iterables.transform(((Map)this.nodes.get()).values(), (Function)this.converter);
    }

    public Iterable<Location> listLocations() {
        return this.locationSupplier.get();
    }

    public NodeMetadata getNode(String id) {
        Node node = (Node)((Map)this.nodes.get()).get(id);
        return node != null ? this.converter.apply(node) : null;
    }

    public void destroyNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void rebootNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException();
    }
}

