/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Node {
    public String id;
    public String name;
    public String description;
    public String hostname;
    public String os_arch;
    public String os_family;
    public String os_description;
    public String os_version;
    public String group;
    public List<String> tags;
    public String username;
    public String credential;
    public String credential_url;
    public String sudo_password;

    public Node() {
    }

    public Node(String id, String name, String description, String hostname, String osArch, String osFamily, String osDescription, String osVersion, String group, List<String> tags, String username, String credential, URI credentialUrl, String sudo_password) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.hostname = hostname;
        this.os_arch = osArch;
        this.os_family = osFamily;
        this.os_description = osDescription;
        this.os_version = osVersion;
        this.group = group;
        this.tags = ImmutableList.copyOf(tags);
        this.username = username;
        this.credential = credential;
        this.credential_url = credentialUrl != null ? credentialUrl.toASCIIString() : null;
        this.sudo_password = sudo_password;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroup() {
        return this.group;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getOsArch() {
        return this.os_arch;
    }

    public String getOsFamily() {
        return this.os_family;
    }

    public String getOsDescription() {
        return this.os_description;
    }

    public String getOsVersion() {
        return this.os_version;
    }

    public Set<String> getTags() {
        HashSet<String> tagSet = new HashSet<String>();
        for (String tag : this.tags) {
            tagSet.add(tag);
        }
        return tagSet;
    }

    public String getUsername() {
        return this.username;
    }

    public String getCredential() {
        return this.credential;
    }

    public URI getCredentialUrl() {
        return this.credential_url != null ? URI.create(this.credential_url) : null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String getSudoPassword() {
        return this.sudo_password;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        return Objects.equal((Object)this.toString(), (Object)that.toString());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("name", (Object)this.name).add("description", (Object)this.description).add("hostname", (Object)this.hostname).add("osArch", (Object)this.os_arch).add("osFamily", (Object)this.os_family).add("osDescription", (Object)this.os_description).add("osVersion", (Object)this.os_version).add("group", (Object)this.group).add("tags", this.tags).add("username", (Object)this.username).add("hasCredential", (Object)(this.credential != null || this.credential_url != null ? 1 : 0)).add("hasSudoPassword", (Object)(this.sudo_password != null ? 1 : 0)).toString();
    }
}

