/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Singleton
public class NodesFromYaml
implements Function<InputStream, Map<String, Node>> {
    public Map<String, Node> apply(InputStream source) {
        Constructor constructor = new Constructor(Config.class);
        TypeDescription nodeDesc = new TypeDescription(Node.class);
        nodeDesc.putListPropertyType("tags", String.class);
        constructor.addTypeDescription(nodeDesc);
        TypeDescription configDesc = new TypeDescription(Config.class);
        configDesc.putListPropertyType("nodes", Node.class);
        constructor.addTypeDescription(configDesc);
        Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
        Config config = (Config)yaml.load(source);
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"missing config: class");
        Preconditions.checkState((config.nodes != null ? 1 : 0) != 0, (Object)"missing nodes: collection");
        return Maps.uniqueIndex(config.nodes, (Function)new Function<Node, String>(){

            public String apply(Node node) {
                return node.getId();
            }
        });
    }

    public static class Config {
        public List<Node> nodes;
    }
}

