/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.byon.functions.NodeToNodeMetadataTest;
import org.jclouds.byon.functions.NodesFromYamlTest;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.domain.Location;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BYONComputeServiceTest {
    @Test
    public void testNodesParseWithFileUrl() throws Exception {
        this.assertNodesParse("file://" + this.getClass().getResource("/test1.yaml").getPath());
    }

    @Test
    public void testNodesParseWithClasspathUrl() throws Exception {
        this.assertNodesParse("classpath:///test1.yaml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNodesParse(String endpoint) {
        ComputeServiceContext context = null;
        try {
            Location providerLocation = NodeToNodeMetadataTest.expectedProviderLocationFromResource(endpoint);
            Properties props = new Properties();
            props.setProperty("byon.endpoint", endpoint);
            context = new ComputeServiceContextFactory().createContext("byon", "foo", "bar", (Iterable)ImmutableSet.of((Object)new JschSshClientModule()), props);
            Assert.assertEquals((Object)context.getProviderSpecificContext().getEndpoint(), (Object)URI.create(endpoint));
            Supplier supplier = (Supplier)context.getProviderSpecificContext().getApi();
            Assert.assertEquals((int)((Map)supplier.get()).size(), (int)context.getComputeService().listNodes().size());
            Assert.assertEquals((Map)((Map)supplier.get()), (Map)ImmutableMap.of((Object)NodesFromYamlTest.TEST1.getId(), (Object)NodesFromYamlTest.TEST1));
            Assert.assertEquals((Set)context.getComputeService().listNodes(), (Set)ImmutableSet.of((Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(endpoint)));
            Assert.assertEquals((Set)context.getComputeService().listAssignableLocations(), (Set)ImmutableSet.of((Object)providerLocation));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNodesWithLocations() {
        ComputeServiceContext context = null;
        try {
            String endpoint = "file://" + this.getClass().getResource("/test_location.yaml").getPath();
            Properties props = new Properties();
            props.setProperty("byon.endpoint", endpoint);
            context = new ComputeServiceContextFactory().createContext("byon", "foo", "bar", (Iterable)ImmutableSet.of((Object)new JschSshClientModule()), props);
            Assert.assertEquals((Object)context.getProviderSpecificContext().getEndpoint(), (Object)URI.create(endpoint));
            Supplier supplier = (Supplier)context.getProviderSpecificContext().getApi();
            Assert.assertEquals((int)((Map)supplier.get()).size(), (int)context.getComputeService().listNodes().size());
            Assert.assertEquals((Map)((Map)supplier.get()), (Map)ImmutableMap.of((Object)NodesFromYamlTest.TEST2.getId(), (Object)NodesFromYamlTest.TEST2, (Object)NodesFromYamlTest.TEST3.getId(), (Object)NodesFromYamlTest.TEST3));
            Location providerLocation = NodeToNodeMetadataTest.expectedProviderLocationFromResource(endpoint);
            Location virginia = NodeToNodeMetadataTest.zoneCalled("virginia", providerLocation);
            Location maryland = NodeToNodeMetadataTest.zoneCalled("maryland", providerLocation);
            Assert.assertEquals((Set)context.getComputeService().listNodes(), (Set)ImmutableSet.of((Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(1, endpoint, virginia), (Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(2, endpoint, maryland)));
            Assert.assertEquals((Set)context.getComputeService().listAssignableLocations(), (Set)ImmutableSet.of((Object)virginia, (Object)maryland));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }
}

