/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.domain;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.byon.Node;
import org.jclouds.util.Strings2;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlNode {
    public String id;
    public String name;
    public String description;
    public String hostname;
    public String location_id;
    public String os_arch;
    public String os_family;
    public String os_description;
    public String os_version;
    public boolean os_64bit;
    public String group;
    public List<String> tags = Lists.newArrayList();
    public String username;
    public String credential;
    public String credential_url;
    public String sudo_password;
    public static Function<YamlNode, Node> toNode = new Function<YamlNode, Node>(){

        public Node apply(YamlNode arg0) {
            if (arg0 == null) {
                return null;
            }
            return Node.builder().id(arg0.id).name(arg0.name).description(arg0.description).locationId(arg0.location_id).hostname(arg0.hostname).osArch(arg0.os_arch).osFamily(arg0.os_family).osDescription(arg0.os_description).osVersion(arg0.os_version).os64Bit(arg0.os_64bit).group(arg0.group).tags(arg0.tags).username(arg0.username).credential(arg0.credential).credentialUrl(arg0.credential_url != null ? URI.create(arg0.credential_url) : null).sudoPassword(arg0.sudo_password).build();
        }
    };
    public static Function<InputStream, YamlNode> inputStreamToYamlNode = new Function<InputStream, YamlNode>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public YamlNode apply(InputStream in) {
            if (in == null) {
                return null;
            }
            try {
                YamlNode yamlNode = (YamlNode)new Yaml(new Loader((BaseConstructor)new Constructor(YamlNode.class))).load(in);
                return yamlNode;
            }
            finally {
                Closeables.closeQuietly((Closeable)in);
            }
        }
    };
    public static Function<YamlNode, InputStream> yamlNodeToInputStream = new Function<YamlNode, InputStream>(){

        public InputStream apply(YamlNode in) {
            if (in == null) {
                return null;
            }
            ImmutableMap.Builder prettier = ImmutableMap.builder();
            if (in.id != null) {
                prettier.put((Object)"id", (Object)in.id);
            }
            if (in.name != null) {
                prettier.put((Object)"name", (Object)in.name);
            }
            if (in.description != null) {
                prettier.put((Object)"description", (Object)in.description);
            }
            if (in.hostname != null) {
                prettier.put((Object)"hostname", (Object)in.hostname);
            }
            if (in.location_id != null) {
                prettier.put((Object)"location_id", (Object)in.location_id);
            }
            if (in.os_arch != null) {
                prettier.put((Object)"os_arch", (Object)in.os_arch);
            }
            if (in.os_family != null) {
                prettier.put((Object)"os_family", (Object)in.os_family);
            }
            if (in.os_description != null) {
                prettier.put((Object)"os_description", (Object)in.os_description);
            }
            if (in.os_version != null) {
                prettier.put((Object)"os_version", (Object)in.os_version);
            }
            if (in.os_64bit) {
                prettier.put((Object)"os_64bit", (Object)in.os_64bit);
            }
            if (in.group != null) {
                prettier.put((Object)"group", (Object)in.group);
            }
            if (in.tags.size() != 0) {
                prettier.put((Object)"tags", in.tags);
            }
            if (in.username != null) {
                prettier.put((Object)"username", (Object)in.username);
            }
            if (in.credential != null) {
                prettier.put((Object)"credential", (Object)in.credential);
            }
            if (in.credential_url != null) {
                prettier.put((Object)"credential_url", (Object)in.credential_url);
            }
            if (in.sudo_password != null) {
                prettier.put((Object)"sudo_password", (Object)in.sudo_password);
            }
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            return Strings2.toInputStream((String)new Yaml(options).dump((Object)prettier.build()));
        }
    };
    public static Function<Node, YamlNode> nodeToYamlNode = new Function<Node, YamlNode>(){

        public YamlNode apply(Node arg0) {
            if (arg0 == null) {
                return null;
            }
            YamlNode yaml = new YamlNode();
            yaml.id = arg0.getId();
            yaml.name = arg0.getName();
            yaml.description = arg0.getDescription();
            yaml.hostname = arg0.getHostname();
            yaml.location_id = arg0.getLocationId();
            yaml.os_arch = arg0.getOsArch();
            yaml.os_family = arg0.getOsFamily();
            yaml.os_description = arg0.getOsDescription();
            yaml.os_version = arg0.getOsVersion();
            yaml.os_64bit = arg0.isOs64Bit();
            yaml.group = arg0.getGroup();
            yaml.tags = ImmutableList.copyOf(arg0.getTags());
            yaml.username = arg0.getUsername();
            yaml.credential = arg0.getCredential();
            yaml.credential_url = arg0.getCredentialUrl() != null ? arg0.getCredentialUrl().toASCIIString() : null;
            yaml.sudo_password = arg0.getSudoPassword();
            return yaml;
        }
    };

    public Node toNode() {
        return (Node)toNode.apply((Object)this);
    }

    public static YamlNode fromYaml(InputStream in) {
        return (YamlNode)inputStreamToYamlNode.apply((Object)in);
    }

    public InputStream toYaml() {
        return (InputStream)yamlNodeToInputStream.apply((Object)this);
    }

    public static YamlNode fromNode(Node in) {
        return (YamlNode)nodeToYamlNode.apply((Object)in);
    }
}

