/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class NodesParsedFromSupplier
implements Supplier<Map<String, Node>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<InputStream> supplier;
    private final Function<InputStream, Map<String, Node>> parser;

    @Inject
    NodesParsedFromSupplier(@Provider Supplier<InputStream> supplier, Function<InputStream, Map<String, Node>> parser) {
        this.supplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"supplier");
        this.parser = (Function)Preconditions.checkNotNull(parser, (Object)"parser");
    }

    public Map<String, Node> get() {
        Map nodes = (Map)this.parser.apply(this.supplier.get());
        Preconditions.checkState((nodes != null && nodes.size() > 0 ? 1 : 0) != 0, (String)"no nodes parsed from supplier: %s", (Object[])new Object[]{this.supplier});
        return nodes;
    }
}

