/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

public class SupplyFromProviderURIOrNodesProperty
implements Supplier<InputStream>,
Function<URI, InputStream> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final URI url;
    @Inject(optional=true)
    @Named(value="byon.nodes")
    @VisibleForTesting
    String nodes;

    @Inject
    public SupplyFromProviderURIOrNodesProperty(@Provider URI url) {
        this.url = (URI)Preconditions.checkNotNull((Object)url, (Object)"url");
    }

    public InputStream get() {
        if (this.nodes != null) {
            return Strings2.toInputStream((String)this.nodes);
        }
        return this.apply(this.url);
    }

    public String toString() {
        return "[url=" + this.url + "]";
    }

    public InputStream apply(URI input) {
        try {
            if (input.getScheme() != null && input.getScheme().equals("classpath")) {
                return this.getClass().getResourceAsStream(input.getPath());
            }
            return input.toURL().openStream();
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "URI could not be read: %s", new Object[]{this.url});
            Throwables.propagate((Throwable)e);
            return null;
        }
    }
}

