/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.io.InputSupplier;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.ConfiguresNodeStore;
import org.jclouds.byon.domain.YamlNode;
import org.jclouds.collect.TransformingMap;
import org.jclouds.io.CopyInputStreamInputSupplierMap;

@ConfiguresNodeStore
@Beta
public class YamlNodeStoreModule
extends AbstractModule {
    private static final Map<String, InputSupplier<InputStream>> BACKING = new ConcurrentHashMap<String, InputSupplier<InputStream>>();
    private final Map<String, InputStream> backing;

    public YamlNodeStoreModule(Map<String, InputStream> backing) {
        this.backing = backing;
    }

    public YamlNodeStoreModule() {
        this(null);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Function<YamlNode, InputStream>>(){}).toInstance(YamlNode.yamlNodeToInputStream);
        this.bind((TypeLiteral)new TypeLiteral<Function<InputStream, YamlNode>>(){}).toInstance(YamlNode.inputStreamToYamlNode);
        this.bind((TypeLiteral)new TypeLiteral<Function<Node, YamlNode>>(){}).toInstance(YamlNode.nodeToYamlNode);
        this.bind((TypeLiteral)new TypeLiteral<Function<YamlNode, Node>>(){}).toInstance(YamlNode.toNode);
        if (this.backing != null) {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}).toInstance(this.backing);
        } else {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputSupplier<InputStream>>>(){}).toInstance(BACKING);
            this.bind((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}).to((TypeLiteral)new TypeLiteral<CopyInputStreamInputSupplierMap>(){});
        }
    }

    @Provides
    @Singleton
    protected Map<String, Node> provideNodeStore(Map<String, YamlNode> backing, Function<Node, YamlNode> yamlSerializer, Function<YamlNode, Node> yamlDeserializer) {
        return new TransformingMap(backing, yamlDeserializer, yamlSerializer);
    }

    @Provides
    @Singleton
    protected Map<String, YamlNode> provideYamlStore(Map<String, InputStream> backing, Function<YamlNode, InputStream> yamlSerializer, Function<InputStream, YamlNode> yamlDeserializer) {
        return new TransformingMap(backing, yamlDeserializer, yamlSerializer);
    }
}

