/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.YamlNodeStoreModule;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.yaml.snakeyaml.Yaml;

@Test(groups={"unit"}, singleThreaded=true)
public class YamlNodeStoreModuleTest {
    Yaml json = (Yaml)this.createInjector().getInstance(Yaml.class);

    @DataProvider(name="names")
    public Object[][] createData() {
        return new Object[][]{{"instance1", "bear"}, {"instance2", "apple"}, {"instance2", "francis"}, {"instance4", "robot"}};
    }

    @Test(dataProvider="names")
    public void deleteObject(String id, String name) throws InterruptedException, IOException {
        Injector injector = this.createInjector();
        Map<String, InputStream> map = this.getMap(injector);
        this.check(map, this.getStore(injector), "i-20312", id, name);
    }

    public void testProvidedMapWithValue() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        map.put("test", new ByteArrayInputStream("id: instance1\nname: instancename\n".getBytes()));
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.remove((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test");
    }

    public void testProvidedConsistentAcrossRepeatedWrites() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        Injector injector = this.createInjectorWithProvidedMap((Map<String, InputStream>)map);
        Assert.assertEquals((Map)((Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}))), (Map)map);
        Map<String, Node> store = this.getStore(injector);
        for (int i = 0; i < 10; ++i) {
            this.check((Map<String, InputStream>)map, store, "test" + i, "instance1" + i, "instancename" + i);
        }
    }

    public void testProvidedConsistentAcrossMultipleInjectors() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        this.put((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.remove((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test");
    }

    public void testDefaultConsistentAcrossMultipleInjectors() throws IOException {
        Map<String, InputStream> map = this.getMap(this.createInjector());
        this.put(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    protected Map<String, Node> getStore(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, Node>>(){}));
    }

    protected Map<String, InputStream> getMap(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}));
    }

    protected Injector createInjectorWithProvidedMap(Map<String, InputStream> map) {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule(map)});
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule()});
    }

    protected void check(Map<String, InputStream> map, Map<String, Node> store, String key, String id, String name) throws IOException {
        this.put(map, store, key, id, name);
        this.checkConsistent(map, store, key, id, name);
        this.remove(map, store, key);
    }

    protected void remove(Map<String, InputStream> map, Map<String, Node> store, String key) {
        store.remove(key);
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertEquals((int)map.size(), (int)0);
        Assert.assertEquals((Object)store.get(key), null);
        Assert.assertEquals((Object)map.get(key), null);
    }

    protected void checkConsistent(Map<String, InputStream> map, Map<String, Node> store, String key, String id, String name) throws IOException {
        Assert.assertEquals((int)store.size(), (int)1);
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals((Object)store.get(key), (Object)Node.builder().id(id).name(name).build());
        Assert.assertEquals((Object)store.get(key), (Object)Node.builder().id(id).name(name).build());
        this.checkToYaml(map, key, id, name);
        this.checkToYaml(map, key, id, name);
    }

    protected void checkToYaml(Map<String, InputStream> map, String key, String id, String name) throws IOException {
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)map.get(key)), (String)String.format("id: %s\nname: %s\n", id, name));
    }

    protected void put(Map<String, InputStream> map, Map<String, Node> store, String key, String id, String name) {
        Assert.assertEquals((int)store.size(), (int)0);
        Assert.assertEquals((int)map.size(), (int)0);
        store.put(key, Node.builder().id(id).name(name).build());
    }
}

