/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.byon.functions.NodeToNodeMetadata;
import org.jclouds.byon.functions.NodesFromYamlTest;
import org.jclouds.byon.suppliers.SupplyFromProviderURIOrNodesProperty;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodeToNodeMetadataTest {
    String resource = "location";
    Location provider = NodeToNodeMetadataTest.expectedProviderLocationFromResource(this.resource);
    Map<String, Credentials> credentialStore = Maps.newLinkedHashMap();
    NodeToNodeMetadata parser = new NodeToNodeMetadata(Suppliers.ofInstance((Object)this.provider), Suppliers.ofInstance((Object)ImmutableSet.of((Object)this.provider, (Object)NodeToNodeMetadataTest.zoneCalled("virginia", this.provider))), (Function)new SupplyFromProviderURIOrNodesProperty(URI.create("test")), this.credentialStore);

    public static Location expectedProviderLocationFromResource(String resource) {
        return new LocationBuilder().scope(LocationScope.PROVIDER).id("byon").description(resource).build();
    }

    public static Location zoneCalled(String zone, Location parent) {
        return new LocationBuilder().scope(LocationScope.ZONE).id(zone).description(zone).parent(parent).build();
    }

    public static NodeMetadata expectedNodeMetadataFromResource(String resource) {
        return NodeToNodeMetadataTest.expectedNodeMetadataFromResource(resource, NodeToNodeMetadataTest.expectedProviderLocationFromResource(resource));
    }

    public static NodeMetadata expectedNodeMetadataFromResource(String resource, Location location) {
        return NodeToNodeMetadataTest.expectedNodeMetadataFromResource(1, resource, location);
    }

    public static NodeMetadata expectedNodeMetadataFromResource(int id, String resource, Location location) {
        return new NodeMetadataBuilder().ids("cluster-" + id).group("hadoop").name("cluster-" + id).hostname("cluster-" + id + ".mydomain.com").location(location).state(NodeState.RUNNING).operatingSystem(OperatingSystem.builder().description("redhat").family(OsFamily.RHEL).arch("x86").version("5.3").build()).publicAddresses((Iterable)ImmutableSet.of((Object)("cluster-" + id + ".mydomain.com"))).credentials(new Credentials("myUser", NodesFromYamlTest.key)).adminPassword("happy bear").build();
    }

    @Test
    public void testNodesParse() throws Exception {
        Assert.assertEquals((Object)this.parser.apply(NodesFromYamlTest.TEST1), (Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(this.resource, this.provider));
        Assert.assertEquals(this.credentialStore, (Map)ImmutableMap.of((Object)"node#cluster-1", (Object)new Credentials("myUser", NodesFromYamlTest.key)));
    }

    @Test
    public void testNodesParseLocation() throws Exception {
        Assert.assertEquals((Object)this.parser.apply(NodesFromYamlTest.TEST2), (Object)NodeToNodeMetadataTest.expectedNodeMetadataFromResource(this.resource, NodeToNodeMetadataTest.zoneCalled("virginia", this.provider)));
        Assert.assertEquals(this.credentialStore, (Map)ImmutableMap.of((Object)"node#cluster-1", (Object)new Credentials("myUser", NodesFromYamlTest.key)));
    }
}

