/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import java.util.Map;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.ConfiguresNodeStore;

@ConfiguresNodeStore
@Beta
public class CacheNodeStoreModule
extends AbstractModule {
    private final Cache<String, Node> backing;

    public CacheNodeStoreModule(Cache<String, Node> backing) {
        this.backing = (Cache)Preconditions.checkNotNull(backing, (Object)"backing");
    }

    public CacheNodeStoreModule(Map<String, Node> backing) {
        this((Cache<String, Node>)CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap(backing))));
        for (String node : backing.keySet()) {
            this.backing.getUnchecked((Object)node);
        }
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Cache<String, Node>>(){}).toInstance(this.backing);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Cache<String, Node>>>(){}).toInstance((Object)Suppliers.ofInstance(this.backing));
    }
}

