/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.domain.YamlNode;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Singleton
public class NodesFromYamlStream
implements Function<InputStream, Cache<String, Node>> {
    public Cache<String, Node> apply(InputStream source) {
        Constructor constructor = new Constructor(Config.class);
        TypeDescription nodeDesc = new TypeDescription(YamlNode.class);
        nodeDesc.putListPropertyType("tags", String.class);
        constructor.addTypeDescription(nodeDesc);
        TypeDescription configDesc = new TypeDescription(Config.class);
        configDesc.putListPropertyType("nodes", YamlNode.class);
        constructor.addTypeDescription(configDesc);
        Yaml yaml = new Yaml(new Loader((BaseConstructor)constructor));
        Config config = (Config)yaml.load(source);
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"missing config: class");
        Preconditions.checkState((config.nodes != null ? 1 : 0) != 0, (Object)"missing nodes: collection");
        ImmutableMap backingMap = Maps.uniqueIndex((Iterable)Iterables.transform(config.nodes, YamlNode.toNode), (Function)new Function<Node, String>(){

            public String apply(Node node) {
                return node.getId();
            }
        });
        Cache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)backingMap)));
        for (String node : backingMap.keySet()) {
            cache.getUnchecked((Object)node);
        }
        return cache;
    }

    public static class Config {
        public List<YamlNode> nodes;
    }
}

