/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.YamlNodeStoreModule;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.location.Provider;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.yaml.snakeyaml.Yaml;

@Test(groups={"unit"}, singleThreaded=true)
public class YamlNodeStoreModuleTest {
    Yaml yaml = (Yaml)this.createInjector().getInstance(Yaml.class);

    @DataProvider(name="names")
    public Object[][] createData() {
        return new Object[][]{{"instance1", "bear"}, {"instance2", "apple"}, {"instance2", "francis"}, {"instance4", "robot"}};
    }

    @Test(dataProvider="names")
    public void deleteObject(String id, String name) throws InterruptedException, IOException {
        Injector injector = this.createInjector();
        Map<String, InputStream> map = this.getMap(injector);
        this.check(map, this.getStore(injector), "i-20312", id, name);
    }

    public void testProvidedMapWithValue() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        map.put("test", new ByteArrayInputStream("id: instance1\nname: instancename\n".getBytes()));
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.remove((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test");
    }

    public void testProvidedConsistentAcrossRepeatedWrites() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        Injector injector = this.createInjectorWithProvidedMap((Map<String, InputStream>)map);
        Assert.assertEquals((Map)((Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}, (Annotation)Names.named((String)"yaml")))), (Map)map);
        LoadingCache<String, Node> store = this.getStore(injector);
        for (int i = 0; i < 10; ++i) {
            this.check((Map<String, InputStream>)map, store, "test" + i, "instance1" + i, "instancename" + i);
        }
    }

    public void testProvidedConsistentAcrossMultipleInjectors() throws IOException {
        CopyInputStreamInputSupplierMap map = new CopyInputStreamInputSupplierMap(new ConcurrentHashMap());
        this.put((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.checkConsistent((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test", "instance1", "instancename");
        this.remove((Map<String, InputStream>)map, this.getStore(this.createInjectorWithProvidedMap((Map<String, InputStream>)map)), "test");
    }

    public void testDefaultConsistentAcrossMultipleInjectors() throws IOException {
        Map<String, InputStream> map = this.getMap(this.createInjector());
        this.put(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.checkConsistent(map, this.getStore(this.createInjector()), "test", "instance1", "instancename");
        this.remove(map, this.getStore(this.createInjector()), "test");
    }

    protected LoadingCache<String, Node> getStore(Injector injector) {
        return (LoadingCache)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<LoadingCache<String, Node>>(){}));
    }

    protected Map<String, InputStream> getMap(Injector injector) {
        return (Map)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Map<String, InputStream>>(){}, (Annotation)Names.named((String)"yaml")));
    }

    protected Injector createInjectorWithProvidedMap(Map<String, InputStream> map) {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule(map), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<InputStream>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance(null));
            }
        }});
    }

    protected Injector createInjector() {
        return Guice.createInjector((Module[])new Module[]{new YamlNodeStoreModule(), new AbstractModule(){

            protected void configure() {
                this.bind((TypeLiteral)new TypeLiteral<Supplier<InputStream>>(){}).annotatedWith(Provider.class).toInstance((Object)Suppliers.ofInstance(null));
            }
        }});
    }

    protected void check(Map<String, InputStream> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        this.put(map, store, key, id, name);
        this.checkConsistent(map, store, key, id, name);
        this.remove(map, store, key);
    }

    protected void remove(Map<String, InputStream> map, LoadingCache<String, Node> store, String key) {
        store.invalidate((Object)key);
        Assert.assertEquals((long)store.size(), (long)0L);
        map.remove(key);
        Assert.assertEquals((int)map.size(), (int)0);
        try {
            Assert.assertEquals((Object)store.getUnchecked((Object)key), null);
            assert (false) : "should not work as null is invalid";
        }
        catch (UncheckedExecutionException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)map.get(key), null);
    }

    protected void checkConsistent(Map<String, InputStream> map, LoadingCache<String, Node> store, String key, String id, String name) throws IOException {
        Assert.assertEquals((int)map.size(), (int)1);
        if (store.size() == 0L) {
            store.getUnchecked((Object)key);
        }
        Assert.assertEquals((long)store.size(), (long)1L);
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
        Assert.assertEquals((Object)store.getUnchecked((Object)key), (Object)Node.builder().id(id).name(name).build());
        this.checkToYaml(map, key, id, name);
        this.checkToYaml(map, key, id, name);
    }

    protected void checkToYaml(Map<String, InputStream> map, String key, String id, String name) throws IOException {
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)map.get(key)), (String)String.format("id: %s\nname: %s\n", id, name));
    }

    protected void put(Map<String, InputStream> map, LoadingCache<String, Node> store, String key, String id, String name) {
        Assert.assertEquals((long)store.size(), (long)0L);
        Assert.assertEquals((int)map.size(), (int)0);
        map.put(key, new ByteArrayInputStream(String.format("id: %s\nname: %s\n", id, name).getBytes()));
        store.getUnchecked((Object)key);
    }
}

