/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.byon.functions.NodeToNodeMetadata;
import org.jclouds.compute.JCloudsNativeComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.JustProvider;

@Singleton
public class BYONComputeServiceAdapter
implements JCloudsNativeComputeServiceAdapter {
    private final Supplier<LoadingCache<String, Node>> nodes;
    private final NodeToNodeMetadata converter;
    private final JustProvider locationSupplier;

    @Inject
    public BYONComputeServiceAdapter(Supplier<LoadingCache<String, Node>> nodes, NodeToNodeMetadata converter, JustProvider locationSupplier) {
        this.nodes = (Supplier)Preconditions.checkNotNull(nodes, (Object)"nodes");
        this.converter = (NodeToNodeMetadata)Preconditions.checkNotNull((Object)converter, (Object)"converter");
        this.locationSupplier = (JustProvider)Preconditions.checkNotNull((Object)locationSupplier, (Object)"locationSupplier");
    }

    public JCloudsNativeComputeServiceAdapter.NodeWithInitialCredentials createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Hardware> listHardwareProfiles() {
        return ImmutableSet.of();
    }

    public Iterable<Image> listImages() {
        return ImmutableSet.of();
    }

    public Iterable<NodeMetadata> listNodes() {
        return Iterables.transform(((LoadingCache)this.nodes.get()).asMap().values(), (Function)this.converter);
    }

    public Iterable<Location> listLocations() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Location provider = (Location)Iterables.getOnlyElement((Iterable)this.locationSupplier.get());
        ImmutableSet zones = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(((LoadingCache)this.nodes.get()).asMap().values(), (Function)new Function<Node, String>(){

            public String apply(Node arg0) {
                return arg0.getLocationId();
            }
        }), (Predicate)Predicates.notNull()));
        if (zones.size() == 0) {
            return locations.add((Object)provider).build();
        }
        for (String zone : zones) {
            locations.add((Object)new LocationBuilder().scope(LocationScope.ZONE).id(zone).description(zone).parent(provider).build());
        }
        return locations.build();
    }

    public NodeMetadata getNode(String id) {
        Node node = null;
        try {
            node = (Node)((LoadingCache)this.nodes.get()).getUnchecked((Object)id);
        }
        catch (UncheckedExecutionException uncheckedExecutionException) {
            // empty catch block
        }
        return node != null ? this.converter.apply(node) : null;
    }

    public void destroyNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void rebootNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void resumeNode(String id) {
        throw new UnsupportedOperationException();
    }

    public void suspendNode(String id) {
        throw new UnsupportedOperationException();
    }
}

