/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.jclouds.sqs.domain.BatchResult;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.domain.MessageIdAndMD5;
import org.jclouds.sqs.features.MessageApi;
import org.jclouds.sqs.internal.BaseSQSApiLiveTest;
import org.jclouds.sqs.options.ReceiveMessageOptions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.testng.internal.annotations.Sets;

@Test(groups={"live"}, singleThreaded=true, testName="BulkMessageApiLiveTest")
public class BulkMessageApiLiveTest
extends BaseSQSApiLiveTest {
    private ImmutableMap<String, String> idPayload;
    private Iterable<String> receiptHandles;

    public BulkMessageApiLiveTest() {
        this.prefix = this.prefix + "-bulk";
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < 10; ++i) {
            String message = "hardyharhar" + i;
            builder.put((Object)(i + ""), (Object)message);
        }
        this.idPayload = builder.build();
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.recreateQueueInRegion(this.prefix, null);
    }

    public void testSendMessages() {
        for (URI queue : this.queues) {
            BatchResult acks = this.api().getMessageApiForQueue(queue).send(this.idPayload);
            Assert.assertEquals((int)acks.size(), (int)this.idPayload.size(), (String)("error sending " + acks));
            Assert.assertEquals((Set)acks.keySet(), (Set)this.idPayload.keySet());
            for (Map.Entry entry : acks.entrySet()) {
                Assert.assertEquals((Object)((MessageIdAndMD5)entry.getValue()).getMD5(), (Object)Hashing.md5().hashString((CharSequence)this.idPayload.get(entry.getKey()), Charsets.UTF_8), (String)("bad md5 for: " + entry));
            }
        }
    }

    @Test(dependsOnMethods={"testSendMessages"})
    public void testChangeMessageVisibility() {
        for (URI queue : this.queues) {
            MessageApi api = this.api().getMessageApiForQueue(queue);
            Set<Message> messages = this.collectMessages(api);
            this.receiptHandles = Iterables.transform(messages, (Function)new Function<Message, String>(){

                public String apply(Message in) {
                    return in.getReceiptHandle();
                }
            });
            Assert.assertNull((Object)api.receive());
            BatchResult acks = api.changeVisibility(this.receiptHandles, 0);
            Assert.assertEquals((int)acks.size(), (int)messages.size(), (String)("error changing visibility " + acks));
            Assert.assertEquals((int)this.collectMessages(api).size(), (int)messages.size());
        }
    }

    protected Set<Message> collectMessages(MessageApi api) {
        Set messages = Sets.newLinkedHashSet();
        while (messages.size() != this.idPayload.size()) {
            messages.addAll(api.receive(this.idPayload.size(), ReceiveMessageOptions.Builder.attribute((String)"None").visibilityTimeout(Integer.valueOf(5))).toImmutableSet());
        }
        return messages;
    }

    @Test(dependsOnMethods={"testChangeMessageVisibility"})
    public void testDeleteMessage() throws InterruptedException {
        for (URI queue : this.queues) {
            BatchResult acks = this.api().getMessageApiForQueue(queue).delete(this.receiptHandles);
            Assert.assertEquals((int)acks.size(), (int)Iterables.size(this.receiptHandles), (String)("error deleting messages " + acks));
            this.assertNoMessages(queue);
        }
    }
}

