/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.sqs.binders.BindAttributeNamesToIndexedFormParams;
import org.jclouds.sqs.domain.QueueAttributes;
import org.jclouds.sqs.functions.MapToQueueAttributes;
import org.jclouds.sqs.options.CreateQueueOptions;
import org.jclouds.sqs.options.ListQueuesOptions;
import org.jclouds.sqs.xml.AttributesHandler;
import org.jclouds.sqs.xml.RegexListQueuesResponseHandler;
import org.jclouds.sqs.xml.RegexQueueHandler;
import org.jclouds.sqs.xml.ValueHandler;

@RequestFilters(value={FormSigner.class})
@FormParams(keys={"Version"}, values={"{jclouds.api-version}"})
@VirtualHost
public interface QueueAsyncApi {
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ListQueues"})
    @ResponseParser(value=RegexListQueuesResponseHandler.class)
    public ListenableFuture<FluentIterable<URI>> list();

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"ListQueues"})
    @ResponseParser(value=RegexListQueuesResponseHandler.class)
    public ListenableFuture<FluentIterable<URI>> list(ListQueuesOptions var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateQueue"})
    @ResponseParser(value=RegexQueueHandler.class)
    public ListenableFuture<URI> create(@FormParam(value="QueueName") String var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateQueue"})
    @ResponseParser(value=RegexQueueHandler.class)
    public ListenableFuture<URI> create(@FormParam(value="QueueName") String var1, CreateQueueOptions var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteQueue"})
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> delete(@EndpointParam URI var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "AttributeName.1"}, values={"GetQueueAttributes", "All"})
    @Transform(value=MapToQueueAttributes.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @XMLResponseParser(value=AttributesHandler.class)
    public ListenableFuture<? extends QueueAttributes> getAttributes(@EndpointParam URI var1);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueAttributes"})
    @XMLResponseParser(value=AttributesHandler.class)
    public ListenableFuture<Map<String, String>> getAttributes(@EndpointParam URI var1, @BinderParam(value=BindAttributeNamesToIndexedFormParams.class) Iterable<String> var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"GetQueueAttributes"})
    @XMLResponseParser(value=ValueHandler.class)
    public ListenableFuture<String> getAttribute(@EndpointParam URI var1, @FormParam(value="AttributeName.1") String var2);

    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"SetQueueAttributes"})
    public ListenableFuture<Void> setAttribute(@EndpointParam URI var1, @FormParam(value="Attribute.Name") String var2, @FormParam(value="Attribute.Value") String var3);
}

