/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class CreateQueueOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private ImmutableMap.Builder<String, String> attributes = ImmutableMap.builder();

    public CreateQueueOptions visibilityTimeout(int visibilityTimeout) {
        return this.attribute("VisibilityTimeout", visibilityTimeout + "");
    }

    public CreateQueueOptions attributes(Map<String, String> attributes) {
        this.attributes = ImmutableMap.builder().putAll(attributes);
        return this;
    }

    public CreateQueueOptions attribute(String name, String value) {
        this.attributes.put((Object)name, (Object)value);
        return this;
    }

    public Multimap<String, String> buildFormParameters() {
        Multimap params = super.buildFormParameters();
        ImmutableMap attributes = this.attributes.build();
        if (attributes.size() > 0) {
            int nameIndex = 1;
            for (Map.Entry attribute : attributes.entrySet()) {
                params.put((Object)("Attribute." + nameIndex + ".Name"), attribute.getKey());
                params.put((Object)("Attribute." + nameIndex + ".Value"), attribute.getValue());
                ++nameIndex;
            }
        }
        return params;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes});
    }

    public CreateQueueOptions clone() {
        return new CreateQueueOptions().attributes((Map<String, String>)this.attributes.build());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateQueueOptions other = (CreateQueueOptions)CreateQueueOptions.class.cast(obj);
        return Objects.equal(this.attributes, other.attributes);
    }

    public String toString() {
        ImmutableMap attributes = this.attributes.build();
        return Objects.toStringHelper((Object)this).omitNullValues().add("attributes", attributes.size() > 0 ? attributes : null).toString();
    }

    public static class Builder {
        public static CreateQueueOptions visibilityTimeout(Integer visibilityTimeout) {
            return new CreateQueueOptions().visibilityTimeout(visibilityTimeout);
        }

        public static CreateQueueOptions attribute(String name, String value) {
            return new CreateQueueOptions().attribute(name, value);
        }

        public static CreateQueueOptions attributes(Map<String, String> attributes) {
            return new CreateQueueOptions().attributes(attributes);
        }
    }
}

