/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class ReceiveMessageOptions
extends BaseHttpRequestOptions
implements Cloneable {
    private Integer visibilityTimeout;
    private ImmutableSet.Builder<String> attributes = ImmutableSet.builder();

    public ReceiveMessageOptions visibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
        return this;
    }

    public ReceiveMessageOptions attributes(Iterable<String> attributes) {
        this.attributes = ImmutableSet.builder().addAll(attributes);
        return this;
    }

    public ReceiveMessageOptions attribute(String attribute) {
        this.attributes.add((Object)attribute);
        return this;
    }

    public Multimap<String, String> buildFormParameters() {
        ImmutableSet attributes;
        Multimap params = super.buildFormParameters();
        if (this.visibilityTimeout != null) {
            params.put((Object)"VisibilityTimeout", (Object)this.visibilityTimeout.toString());
        }
        if ((attributes = this.attributes.build()).size() > 0) {
            int nameIndex = 1;
            for (String attribute : attributes) {
                params.put((Object)("AttributeName." + nameIndex), (Object)attribute);
                ++nameIndex;
            }
        }
        return params;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.visibilityTimeout, this.attributes});
    }

    public ReceiveMessageOptions clone() {
        return new ReceiveMessageOptions().visibilityTimeout(this.visibilityTimeout).attributes((Iterable<String>)this.attributes.build());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiveMessageOptions other = (ReceiveMessageOptions)ReceiveMessageOptions.class.cast(obj);
        return Objects.equal((Object)this.visibilityTimeout, (Object)other.visibilityTimeout) && Objects.equal(this.attributes, other.attributes);
    }

    public String toString() {
        ImmutableSet attributes = this.attributes.build();
        return Objects.toStringHelper((Object)this).omitNullValues().add("visibilityTimeout", (Object)this.visibilityTimeout).add("attributes", attributes.size() > 0 ? attributes : null).toString();
    }

    public static class Builder {
        public static ReceiveMessageOptions visibilityTimeout(Integer visibilityTimeout) {
            return new ReceiveMessageOptions().visibilityTimeout(visibilityTimeout);
        }

        public static ReceiveMessageOptions attribute(String attribute) {
            return new ReceiveMessageOptions().attribute(attribute);
        }

        public static ReceiveMessageOptions attributes(Iterable<String> attributes) {
            return new ReceiveMessageOptions().attributes(attributes);
        }
    }
}

