/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.concurrent.Timeout;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.sqs.domain.Action;
import org.jclouds.sqs.domain.QueueAttributes;
import org.jclouds.sqs.internal.BaseSQSApiLiveTest;
import org.jclouds.sqs.xml.ValueHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="PermissionApiLiveTest")
public class PermissionApiLiveTest
extends BaseSQSApiLiveTest {
    public PermissionApiLiveTest() {
        this.prefix = this.prefix + "-permission";
    }

    @BeforeClass(groups={"integration", "live"})
    public void setupContext() {
        super.setupContext();
        this.recreateQueueInRegion(this.prefix, null);
    }

    public void testAddAnonymousPermission() throws InterruptedException {
        for (URI queue : this.queues) {
            QueueAttributes attributes = this.api().getQueueApi().getAttributes(queue);
            this.assertNoPermissions(queue);
            String accountToAuthorize = this.getOwner(queue);
            this.api().getPermissionApiForQueue(queue).addPermissionToAccount("fubar", Action.GET_QUEUE_ATTRIBUTES, accountToAuthorize);
            String policyForAuthorizationByAccount = this.assertPolicyPresent(queue);
            String policyForAnonymous = policyForAuthorizationByAccount.replace("\"" + accountToAuthorize + "\"", "\"*\"");
            this.api().getQueueApi().setAttribute(queue, "Policy", policyForAnonymous);
            Assert.assertEquals((String)this.getAnonymousAttributesApi(queue).getQueueArn(), (String)attributes.getQueueArn());
        }
    }

    @Test(dependsOnMethods={"testAddAnonymousPermission"})
    public void testRemovePermission() throws InterruptedException {
        for (URI queue : this.queues) {
            this.api().getPermissionApiForQueue(queue).remove("fubar");
            this.assertNoPermissions(queue);
        }
    }

    private AnonymousAttributesApi getAnonymousAttributesApi(URI queue) {
        return (AnonymousAttributesApi)ContextBuilder.newBuilder((ProviderMetadata)AnonymousProviderMetadata.forClientMappedToAsyncClientOnEndpoint(AnonymousAttributesApi.class, AnonymousAttributesAsyncApi.class, (String)queue.toASCIIString())).modules((Iterable)ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()))).buildInjector().getInstance(AnonymousAttributesApi.class);
    }

    static interface AnonymousAttributesAsyncApi {
        @POST
        @Path(value="/")
        @FormParams(keys={"Action", "AttributeName.1"}, values={"GetQueueAttributes", "QueueArn"})
        @XMLResponseParser(value=ValueHandler.class)
        public ListenableFuture<String> getQueueArn();
    }

    @Timeout(duration=5L, timeUnit=TimeUnit.SECONDS)
    static interface AnonymousAttributesApi {
        public String getQueueArn();
    }
}

