/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.xml;

import com.google.common.base.Function;
import com.google.common.hash.HashCodes;
import com.google.inject.Singleton;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.sqs.domain.MessageIdAndMD5;

@Singleton
public class RegexMessageIdAndMD5Handler
implements Function<HttpResponse, MessageIdAndMD5> {
    private static final Pattern pattern = Pattern.compile("<MessageId>([\\S&&[^<]]+)</MessageId>\\s*<MD5OfMessageBody>([\\S&&[^<]]+)</MD5OfMessageBody>", 32);
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    public RegexMessageIdAndMD5Handler(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public MessageIdAndMD5 apply(HttpResponse response) {
        Matcher matcher;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = pattern.matcher(content)).find()) {
            return MessageIdAndMD5.builder().id(matcher.group(1)).md5(HashCodes.fromBytes((byte[])CryptoStreams.hex((String)matcher.group(2)))).build();
        }
        return null;
    }
}

