/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.internal.BaseSQSApiExpectTest;
import org.jclouds.sqs.parse.ChangeMessageVisibilityBatchResponseTest;
import org.jclouds.sqs.parse.DeleteMessageBatchResponseTest;
import org.jclouds.sqs.parse.ReceiveMessageResponseTest;
import org.jclouds.sqs.parse.SendMessageBatchResponseTest;
import org.jclouds.sqs.parse.SendMessageResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MessageApiExpectTest")
public class MessageApiExpectTest
extends BaseSQSApiExpectTest {
    public HttpRequest sendMessage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessage"}).addFormParam("MessageBody", new String[]{"hardyharhar"}).addFormParam("Signature", new String[]{"PVzszzgIcT1xt9%2BEzGzWB2Bt8zDadBc48HsgF89AoJE%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageIterable = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"2AYMDMLhoLncALJgBfHBGfOkaTB5ut3PeFRJeWffxdI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageMap = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"f9v8e%2FrPXTI3zhBYMhg7U8yCfvPqHjAV8bFjhGL6%2BXc%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageWithDelayMap = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"COjjEaJ76EwziEFtkT2FuSRSbrCIu%2FhlJf1Zmu7cYoU%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageWithDelayIterable = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"8AVNvSVXPSnoXjJAc6h1rysMBBZPnSycbnmD2%2FqpdV8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageWithDelaysTable = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.DelaySeconds", new String[]{"1"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"M2X8Al%2BbyyDM%2B9kdN28rMn1yJWl78hJ5i4GnaMZ1sYg%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest sendMessageWithDelaysMap = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SendMessageBatch"}).addFormParam("SendMessageBatchRequestEntry.1.DelaySeconds", new String[]{"1"}).addFormParam("SendMessageBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("SendMessageBatchRequestEntry.1.MessageBody", new String[]{"payload1"}).addFormParam("SendMessageBatchRequestEntry.2.DelaySeconds", new String[]{"10"}).addFormParam("SendMessageBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("SendMessageBatchRequestEntry.2.MessageBody", new String[]{"payload2"}).addFormParam("Signature", new String[]{"nbA4UnKDAuQCiCcvQHH%2F1UjMMeo2s3d94A27Q3t9SlI%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest receiveMessage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ReceiveMessage"}).addFormParam("Signature", new String[]{"UURXsAjggoaz5P1h2EFswRd8Ji9euHmXhHvrAmIqM1E%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest receiveMessages = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ReceiveMessage"}).addFormParam("MaxNumberOfMessages", new String[]{"10"}).addFormParam("Signature", new String[]{"pZ9B4%2BTBvQA4n0joP4t8ue5x0xmKMd9prpVLVoT%2F7qU%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest deleteMessage = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DeleteMessage"}).addFormParam("ReceiptHandle", new String[]{"eXJYhj5rDr9cAe"}).addFormParam("Signature", new String[]{"9%2FkuCc2i78gMsmul%2BRsOPcdQ1OLUKrItqgGIRRBJb8M%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest deleteMessageIterable = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DeleteMessageBatch"}).addFormParam("DeleteMessageBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("DeleteMessageBatchRequestEntry.1.ReceiptHandle", new String[]{"eXJYhj5rDr9cAe"}).addFormParam("DeleteMessageBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("DeleteMessageBatchRequestEntry.2.ReceiptHandle", new String[]{"fffeeerrr"}).addFormParam("Signature", new String[]{"S4xIobjm3LOkJvibeI2X54nxKJw9r1a5zj%2FdvHlfDMY%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest deleteMessageMap = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"DeleteMessageBatch"}).addFormParam("DeleteMessageBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("DeleteMessageBatchRequestEntry.1.ReceiptHandle", new String[]{"eXJYhj5rDr9cAe"}).addFormParam("DeleteMessageBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("DeleteMessageBatchRequestEntry.2.ReceiptHandle", new String[]{"fffeeerrr"}).addFormParam("Signature", new String[]{"kwHC3F3ZoJvfibhZWVTeIwFHUzoaVMR4OViyJbsmuV0%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest changeMessageVisibility = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ChangeMessageVisibility"}).addFormParam("ReceiptHandle", new String[]{"eXJYhj5rDr9cAe"}).addFormParam("Signature", new String[]{"gvmSHleGLkmszYU6aURCBImuec2k0O3pg3tAYhDvkNs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("VisibilityTimeout", new String[]{"10"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest changeMessageVisibilityTable = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ChangeMessageVisibilityBatch"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle", new String[]{"aaaaaaaaa"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout", new String[]{"1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.ReceiptHandle", new String[]{"bbbbbbbbb"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.VisibilityTimeout", new String[]{"10"}).addFormParam("Signature", new String[]{"KjDusYiiC3hTdy3ZxLwBRHryrNoNaFb2AHJqUDu3mtQ%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest changeMessageVisibilityMap = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ChangeMessageVisibilityBatch"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle", new String[]{"aaaaaaaaa"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout", new String[]{"1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.ReceiptHandle", new String[]{"bbbbbbbbb"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.VisibilityTimeout", new String[]{"10"}).addFormParam("Signature", new String[]{"zj2cftkpHtiYb9iOjPR3AhcVhoobi0JvOy22PvQJtho%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest changeMessageVisibilityMapInt = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ChangeMessageVisibilityBatch"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.Id", new String[]{"foo1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle", new String[]{"aaaaaaaaa"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout", new String[]{"10"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.Id", new String[]{"foo2"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.ReceiptHandle", new String[]{"bbbbbbbbb"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.VisibilityTimeout", new String[]{"10"}).addFormParam("Signature", new String[]{"y%2FgaaxoE5wrG2P7NIAyfDo7DTgRx2PLJUi9%2FzNnWQ6A%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest changeMessageVisibilityIterableInt = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"ChangeMessageVisibilityBatch"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.Id", new String[]{"1"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.ReceiptHandle", new String[]{"aaaaaaaaa"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.1.VisibilityTimeout", new String[]{"10"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.Id", new String[]{"2"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.ReceiptHandle", new String[]{"bbbbbbbbb"}).addFormParam("ChangeMessageVisibilityBatchRequestEntry.2.VisibilityTimeout", new String[]{"10"}).addFormParam("Signature", new String[]{"f5aq7zdKFErM3%2BIdtDX5NOzPO7mqCRzPGj2wUUEWjgE%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testSendMessageWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessage, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).send("hardyharhar").toString(), (String)new SendMessageResponseTest().expected().toString());
    }

    public void testSendMessageIterableWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageIterable, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).send((Iterable)ImmutableSet.of((Object)"payload1", (Object)"payload2")).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testSendMessageMapWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageMap, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).send((Map)ImmutableMap.of((Object)"foo1", (Object)"payload1", (Object)"foo2", (Object)"payload2")).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testSendMessageWithDelayMapWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageWithDelayMap, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).sendWithDelay((Map)ImmutableMap.builder().put((Object)"foo1", (Object)"payload1").put((Object)"foo2", (Object)"payload2").build(), 10).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testSendMessageWithDelayIterableWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageWithDelayIterable, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).sendWithDelay((Iterable)ImmutableSet.of((Object)"payload1", (Object)"payload2"), 10).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testSendMessageWithDelaysTableWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageWithDelaysTable, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).sendWithDelays((Table)ImmutableTable.builder().put((Object)"foo1", (Object)"payload1", (Object)1).put((Object)"foo2", (Object)"payload2", (Object)10).build()).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testSendMessageWithDelaysMapWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/send_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.sendMessageWithDelaysMap, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).sendWithDelays((Map)ImmutableMap.of((Object)"payload1", (Object)1, (Object)"payload2", (Object)10)).toString(), (String)new SendMessageBatchResponseTest().expected().toString());
    }

    public void testReceiveMessageWhenResponseIs2xx() throws Exception {
        HttpResponse receiveMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/messages.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.receiveMessage, receiveMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).receive().toString(), (String)((Message)Iterables.get(new ReceiveMessageResponseTest().expected(), (int)0)).toString());
    }

    public void testReceiveMessagesWhenResponseIs2xx() throws Exception {
        HttpResponse receiveMessagesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/messages.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.receiveMessages, receiveMessagesResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).receive(10).toString(), (String)new ReceiveMessageResponseTest().expected().toString());
    }

    public void testDeleteMessageWhenResponseIs2xx() throws Exception {
        HttpResponse deleteMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(MessageApiExpectTest.payloadFromStringWithContentType((String)"<DeleteMessageResponse><ResponseMetadata><RequestId>b5293cb5-d306-4a17-9048-b263635abe42</RequestId></ResponseMetadata></DeleteMessageResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.deleteMessage, deleteMessageResponse);
        apiWhenExist.getMessageApiForQueue(this.queue).delete("eXJYhj5rDr9cAe");
    }

    public void testDeleteMessageIterableWhenResponseIs2xx() throws Exception {
        HttpResponse deleteMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/delete_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.deleteMessageIterable, deleteMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).delete((Iterable)ImmutableSet.of((Object)"eXJYhj5rDr9cAe", (Object)"fffeeerrr")).toString(), (String)new DeleteMessageBatchResponseTest().expected().toString());
    }

    public void testDeleteMessageMapWhenResponseIs2xx() throws Exception {
        HttpResponse deleteMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/delete_message_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.deleteMessageMap, deleteMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).delete((Map)ImmutableMap.of((Object)"foo1", (Object)"eXJYhj5rDr9cAe", (Object)"foo2", (Object)"fffeeerrr")).toString(), (String)new DeleteMessageBatchResponseTest().expected().toString());
    }

    public void testChangeMessageVisibilityWhenResponseIs2xx() throws Exception {
        HttpResponse changeMessageVisibilityResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(MessageApiExpectTest.payloadFromStringWithContentType((String)"<ChangeMessageVisibilityResponse><ResponseMetadata><RequestId>b5293cb5-d306-4a17-9048-b263635abe42</RequestId></ResponseMetadata></ChangeMessageVisibilityResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.changeMessageVisibility, changeMessageVisibilityResponse);
        apiWhenExist.getMessageApiForQueue(this.queue).changeVisibility("eXJYhj5rDr9cAe", 10);
    }

    public void testChangeMessageVisibilityTableWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/change_message_visibility_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.changeMessageVisibilityTable, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).changeVisibility((Table)ImmutableTable.builder().put((Object)"foo1", (Object)"aaaaaaaaa", (Object)1).put((Object)"foo2", (Object)"bbbbbbbbb", (Object)10).build()).toString(), (String)new ChangeMessageVisibilityBatchResponseTest().expected().toString());
    }

    public void testChangeMessageVisibilityMapWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/change_message_visibility_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.changeMessageVisibilityMap, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).changeVisibility((Map)ImmutableMap.of((Object)"aaaaaaaaa", (Object)1, (Object)"bbbbbbbbb", (Object)10)).toString(), (String)new ChangeMessageVisibilityBatchResponseTest().expected().toString());
    }

    public void testChangeMessageVisibilityMapIntWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/change_message_visibility_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.changeMessageVisibilityMapInt, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).changeVisibility((Map)ImmutableMap.builder().put((Object)"foo1", (Object)"aaaaaaaaa").put((Object)"foo2", (Object)"bbbbbbbbb").build(), 10).toString(), (String)new ChangeMessageVisibilityBatchResponseTest().expected().toString());
    }

    public void testChangeMessageVisibilityIterableIntWhenResponseIs2xx() throws Exception {
        HttpResponse sendMessageResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/change_message_visibility_batch.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.changeMessageVisibilityIterableInt, sendMessageResponse);
        Assert.assertEquals((String)apiWhenExist.getMessageApiForQueue(this.queue).changeVisibility((Iterable)ImmutableSet.of((Object)"aaaaaaaaa", (Object)"bbbbbbbbb"), 10).toString(), (String)new ChangeMessageVisibilityBatchResponseTest().expected().toString());
    }
}

