/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.functions.MapToQueueAttributesTest;
import org.jclouds.sqs.internal.BaseSQSApiExpectTest;
import org.jclouds.sqs.parse.CreateQueueResponseTest;
import org.jclouds.sqs.parse.GetQueueAttributesResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="QueueApiExpectTest")
public class QueueApiExpectTest
extends BaseSQSApiExpectTest {
    public HttpRequest getQueueUrl = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"GetQueueUrl"}).addFormParam("QueueName", new String[]{"queueName"}).addFormParam("Signature", new String[]{"ZjHLpNl6NLqK%2BsqOyEFqEJMWGeOLuNBd3%2B0Z9RGPYWU%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest getQueueUrlByOwner = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"GetQueueUrl"}).addFormParam("QueueName", new String[]{"queueName"}).addFormParam("QueueOwnerAWSAccountId", new String[]{"120908098979"}).addFormParam("Signature", new String[]{"O0E%2B3jh2vN6bKqmb4%2FXPTHUmPO1iat9o8YnIFH463g8%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest createQueue = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"CreateQueue"}).addFormParam("QueueName", new String[]{"queueName"}).addFormParam("Signature", new String[]{"I7tmwiCzJ9cvw79pmlz1rOILh2C2ZV6OpLk23JGx6AU%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest getQueueAttribute = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"GetQueueAttributes"}).addFormParam("AttributeName.1", new String[]{"VisibilityTimeout"}).addFormParam("Signature", new String[]{"AfydayBBaIk4UGikHHY1CFNmOOAcTnogpFWydZyNass%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest getQueueAttributes = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"GetQueueAttributes"}).addFormParam("AttributeName.1", new String[]{"All"}).addFormParam("Signature", new String[]{"welFLn0TV6JlH6s6s60XZTJeJfFXGiXN4qNPrBx7aHc%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest getQueueAttributesSubset = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"GetQueueAttributes"}).addFormParam("AttributeName.1", new String[]{"VisibilityTimeout"}).addFormParam("AttributeName.2", new String[]{"DelaySeconds"}).addFormParam("Signature", new String[]{"9KaiOOWWyFPTVMOnyHA3ZoXbPBPSD4AZ4q460UNMfDs%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();
    public HttpRequest setQueueAttribute = ((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://sqs.us-east-1.amazonaws.com/993194456877/adrian-sqs11/").addHeader("Host", new String[]{"sqs.us-east-1.amazonaws.com"})).addFormParam("Action", new String[]{"SetQueueAttributes"}).addFormParam("Attribute.Name", new String[]{"MaximumMessageSize"}).addFormParam("Attribute.Value", new String[]{"1"}).addFormParam("Signature", new String[]{"ktBkQ3c%2FrwGcBSec0fkckfo73xmcoTuub5fxudM1qh0%3D"}).addFormParam("SignatureMethod", new String[]{"HmacSHA256"}).addFormParam("SignatureVersion", new String[]{"2"}).addFormParam("Timestamp", new String[]{"2009-11-08T15%3A54%3A08.897Z"}).addFormParam("Version", new String[]{"2011-10-01"}).addFormParam("AWSAccessKeyId", new String[]{"identity"}).build();

    public void testGetQueueUrlWhenResponseIs2xx() throws Exception {
        HttpResponse getQueueUrlResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_queue_url.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueUrl, getQueueUrlResponse);
        Assert.assertEquals((Object)apiWhenExist.getQueueApi().get("queueName"), (Object)URI.create("http://sqs.us-east-1.amazonaws.com/123456789012/testQueue"));
    }

    public void testGetQueueUrlByOwnerWhenResponseIs2xx() throws Exception {
        HttpResponse getQueueUrlResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/get_queue_url.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueUrlByOwner, getQueueUrlResponse);
        Assert.assertEquals((Object)apiWhenExist.getQueueApi().getInAccount("queueName", "120908098979"), (Object)URI.create("http://sqs.us-east-1.amazonaws.com/123456789012/testQueue"));
    }

    public void testGetQueueUrlByOwnerWhenResponseIs400ReturnsNull() throws Exception {
        HttpResponse getQueueUrlResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(QueueApiExpectTest.payloadFromStringWithContentType((String)"<ErrorResponse><Error><Type>Sender</Type><Code>AWS.SimpleQueueService.NonExistentQueue</Code><Message>The specified queue does not exist or you do not have access to it.</Message><Detail/></Error><RequestId>194a169f-4483-5bb1-8cb6-5e4ac865909a</RequestId></ErrorResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueUrlByOwner, getQueueUrlResponse);
        Assert.assertNull((Object)apiWhenExist.getQueueApi().getInAccount("queueName", "120908098979"));
    }

    public void testCreateQueueWhenResponseIs2xx() throws Exception {
        HttpResponse createQueueResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/create_queue.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.createQueue, createQueueResponse);
        Assert.assertEquals((String)apiWhenExist.getQueueApi().create("queueName").toString(), (String)new CreateQueueResponseTest().expected().toString());
    }

    public void testGetQueueAttributeWhenResponseIs2xx() throws Exception {
        HttpResponse getQueueAttributeResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(QueueApiExpectTest.payloadFromStringWithContentType((String)"<GetQueueAttributesResponse><GetQueueAttributesResult><Attribute><Name>VisibilityTimeout</Name><Value>30</Value></Attribute></GetQueueAttributesResult></GetQueueAttributesResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueAttribute, getQueueAttributeResponse);
        Assert.assertEquals((String)apiWhenExist.getQueueApi().getAttribute(this.queue, "VisibilityTimeout"), (String)"30");
    }

    public void testGetQueueAttributesWhenResponseIs2xx() throws Exception {
        HttpResponse getQueueAttributesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/attributes.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueAttributes, getQueueAttributesResponse);
        Assert.assertEquals((String)apiWhenExist.getQueueApi().getAttributes(this.queue).toString(), (String)new MapToQueueAttributesTest().expected().toString());
    }

    public void testGetQueueAttributesSubsetWhenResponseIs2xx() throws Exception {
        HttpResponse getQueueAttributesSubsetResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/attributes.xml", "text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.getQueueAttributesSubset, getQueueAttributesSubsetResponse);
        Assert.assertEquals((String)apiWhenExist.getQueueApi().getAttributes(this.queue, (Iterable)ImmutableSet.of((Object)"VisibilityTimeout", (Object)"DelaySeconds")).toString(), (String)new GetQueueAttributesResponseTest().expected().toString());
    }

    public void testSetQueueAttributeWhenResponseIs2xx() throws Exception {
        HttpResponse setQueueAttributeResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(QueueApiExpectTest.payloadFromStringWithContentType((String)"<SetQueueAttributesResponse><ResponseMetadata><RequestId>b5293cb5-d306-4a17-9048-b263635abe42</RequestId></ResponseMetadata></SetQueueAttributesResponse>", (String)"text/xml"))).build();
        SQSApi apiWhenExist = (SQSApi)this.requestSendsResponse(this.setQueueAttribute, setQueueAttributeResponse);
        apiWhenExist.getQueueApi().setAttribute(this.queue, "MaximumMessageSize", "1");
    }
}

