/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.parse;

import com.google.common.hash.HashCodes;
import java.io.InputStream;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.sqs.domain.MessageIdAndMD5;
import org.jclouds.sqs.xml.RegexMessageIdAndMD5Handler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SendMessageResponseTest")
public class SendMessageResponseTest {
    public void test() {
        InputStream is = this.getClass().getResourceAsStream("/send_message.xml");
        MessageIdAndMD5 expected = this.expected();
        RegexMessageIdAndMD5Handler handler = new RegexMessageIdAndMD5Handler(new ReturnStringIf2xx());
        MessageIdAndMD5 result = handler.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(is)).build());
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public MessageIdAndMD5 expected() {
        return MessageIdAndMD5.builder().id("c332b2b0-b61f-42d3-8832-d03ebd89f68d").md5(HashCodes.fromBytes((byte[])CryptoStreams.hex((String)"e32aedf2b2b25355d04b1507055532e6"))).build();
    }
}

