/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.sqs.SQSApi;
import org.jclouds.sqs.SQSAsyncApi;
import org.jclouds.sqs.config.SQSRestClientModule;

public class SQSApiMetadata
extends BaseRestApiMetadata {
    private static final long serialVersionUID = -7077953935392202824L;
    public static final TypeToken<RestContext<SQSApi, SQSAsyncApi>> CONTEXT_TOKEN = new TypeToken<RestContext<SQSApi, SQSAsyncApi>>(){
        private static final long serialVersionUID = -5070937833892503232L;
    };

    public Builder toBuilder() {
        return new Builder(this.getApi(), this.getAsyncApi()).fromApiMetadata((ApiMetadata)this);
    }

    public SQSApiMetadata() {
        this(new Builder(SQSApi.class, SQSAsyncApi.class));
    }

    protected SQSApiMetadata(Builder builder) {
        super((BaseRestApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseRestApiMetadata.defaultProperties();
        properties.setProperty("jclouds.sqs.create-queue.max-retries", "60");
        properties.setProperty("jclouds.sqs.create-queue.retry-interval", "1000");
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        return properties;
    }

    public static class Builder
    extends BaseRestApiMetadata.Builder {
        protected Builder(Class<?> api, Class<?> asyncApi) {
            super(api, asyncApi);
            this.id("sqs").name("Amazon Simple Queue Service API").identityName("Access Key ID").credentialName("Secret Access Key").version("2011-10-01").defaultProperties(SQSApiMetadata.defaultProperties()).defaultEndpoint("https://sqs.us-east-1.amazonaws.com").documentation(URI.create("http://docs.amazonwebservices.com/AWSSimpleQueueService/latest/APIReference")).defaultModules((Set)ImmutableSet.of(SQSRestClientModule.class));
        }

        public SQSApiMetadata build() {
            return new SQSApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }
    }
}

