/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import org.easymock.EasyMock;
import org.jclouds.sqs.SQS;
import org.jclouds.sqs.domain.Message;
import org.jclouds.sqs.features.MessageApi;
import org.jclouds.sqs.options.ReceiveMessageOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="SQSTest", singleThreaded=true)
public class SQSTest {
    @Test
    public void testSinglePageResult() throws Exception {
        MessageApi messageClient = (MessageApi)EasyMock.createMock(MessageApi.class);
        ReceiveMessageOptions options = new ReceiveMessageOptions();
        FluentIterable aMessage = FluentIterable.from((Iterable)ImmutableSet.of((Object)EasyMock.createMock(Message.class)));
        FluentIterable noMessages = FluentIterable.from((Iterable)ImmutableSet.of());
        EasyMock.expect((Object)messageClient.receive(1, options)).andReturn((Object)aMessage).once();
        EasyMock.expect((Object)messageClient.receive(1, options)).andReturn((Object)noMessages).once();
        EasyMock.replay((Object[])new Object[]{messageClient});
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)SQS.receiveAllAtRate((MessageApi)messageClient, (int)1, (ReceiveMessageOptions)options)));
    }

    @Test
    public void testMultiPageResult() throws Exception {
        MessageApi messageClient = (MessageApi)EasyMock.createMock(MessageApi.class);
        ReceiveMessageOptions options = new ReceiveMessageOptions();
        FluentIterable aMessage = FluentIterable.from((Iterable)ImmutableSet.of((Object)EasyMock.createMock(Message.class)));
        FluentIterable noMessages = FluentIterable.from((Iterable)ImmutableSet.of());
        EasyMock.expect((Object)messageClient.receive(1, options)).andReturn((Object)aMessage).times(2);
        EasyMock.expect((Object)messageClient.receive(1, options)).andReturn((Object)noMessages).once();
        EasyMock.replay((Object[])new Object[]{messageClient});
        Assert.assertEquals((int)2, (int)Iterables.size((Iterable)SQS.receiveAllAtRate((MessageApi)messageClient, (int)1, (ReceiveMessageOptions)options)));
    }
}

