/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.jclouds.sqs.internal.BaseSQSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="QueueApiLiveTest")
public class QueueApiLiveTest
extends BaseSQSApiLiveTest {
    public QueueApiLiveTest() {
        this.prefix = this.prefix + "-queue";
    }

    @Test
    public void testListQueues() throws InterruptedException {
        this.listQueuesInRegion(null);
    }

    protected void listQueuesInRegion(String region) throws InterruptedException {
        FluentIterable allResults = this.api().getQueueApiForRegion(region).list();
        Assert.assertNotNull((Object)allResults);
        if (allResults.size() >= 1) {
            URI queue = (URI)Iterables.getLast((Iterable)allResults);
            this.assertQueueInList(region, queue);
        }
    }

    @Test
    public void testGracefulNoQueue() throws InterruptedException {
        Assert.assertNull((Object)this.api().getQueueApi().get(UUID.randomUUID().toString()));
    }

    @Test
    public void testCanRecreateQueueGracefully() throws InterruptedException {
        this.recreateQueueInRegion(this.prefix, null);
        this.recreateQueueInRegion(this.prefix, null);
    }

    @Test(dependsOnMethods={"testCanRecreateQueueGracefully"})
    public void testCreateQueueWhenAlreadyExistsReturnsURI() {
        for (URI queue : this.queues) {
            Assert.assertEquals((Object)this.api().getQueueApi().create(this.prefix), (Object)queue);
        }
    }

    @Test(dependsOnMethods={"testCanRecreateQueueGracefully"})
    public void testGet() {
        for (URI queue : this.queues) {
            Assert.assertEquals((Object)this.api().getQueueApi().get(this.prefix), (Object)queue);
        }
    }

    @Test(dependsOnMethods={"testCanRecreateQueueGracefully"})
    public void testGetInAccount() {
        for (URI queue : this.queues) {
            Assert.assertEquals((Object)this.api().getQueueApi().getInAccount(this.prefix, this.getOwner(queue)), (Object)queue);
        }
    }

    @Test(dependsOnMethods={"testCanRecreateQueueGracefully"})
    public void testGetQueueAttributes() {
        for (URI queue : this.queues) {
            Map attributes = this.api().getQueueApi().getAttributes(queue, (Iterable)ImmutableSet.of((Object)"All"));
            Assert.assertEquals((Map)this.api().getQueueApi().getAttributes(queue, attributes.keySet()), (Map)attributes);
        }
    }

    @Test(dependsOnMethods={"testGetQueueAttributes"})
    public void testSetQueueAttribute() {
        for (URI queue : this.queues) {
            this.api().getQueueApi().setAttribute(queue, "MaximumMessageSize", "1024");
            Assert.assertEquals((int)this.api().getQueueApi().getAttributes(queue).getMaximumMessageSize(), (int)1024);
        }
    }
}

