/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.sqs.options.ListQueuesOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ListQueuesOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(ListQueuesOptions.class));
        assert (!String.class.isAssignableFrom(ListQueuesOptions.class));
    }

    @Test
    public void testPrefix() {
        ListQueuesOptions options = new ListQueuesOptions();
        options.queuePrefix("test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"QueueNamePrefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test
    public void testNullPrefix() {
        ListQueuesOptions options = new ListQueuesOptions();
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"QueueNamePrefix"), (Collection)ImmutableList.of());
    }

    @Test
    public void testPrefixStatic() {
        ListQueuesOptions options = ListQueuesOptions.Builder.queuePrefix((String)"test");
        Assert.assertEquals((Collection)options.buildFormParameters().get((Object)"QueueNamePrefix"), (Collection)ImmutableList.of((Object)"test"));
    }

    public void testNoPrefix() {
        ListQueuesOptions.Builder.queuePrefix(null);
    }
}

