/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.sqs.handlers;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.sqs.handlers.SQSErrorRetryHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SQSErrorRetryHandlerTest")
public class SQSErrorRetryHandlerTest {
    String code = "AWS.SimpleQueueService.QueueDeletedRecently";
    AWSError error;
    HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(400).payload(String.format("<Error><Code>%s</Code></Error>", this.code))).build();

    public SQSErrorRetryHandlerTest() {
        this.error = new AWSError();
        this.error.setCode(this.code);
    }

    public void testQueueDeletedRecentlyRetriesWhen59SleepsAndTries() {
        SQSErrorRetryHandler retry = new SQSErrorRetryHandler((AWSUtils)EasyMock.createMock(AWSUtils.class), (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class), (Set)ImmutableSet.of(), 60, 100L);
        HttpCommand command = this.createHttpCommandForFailureCount(59);
        Stopwatch watch = new Stopwatch().start();
        Assert.assertTrue((boolean)retry.shouldRetryRequestOnError(command, this.response, this.error));
        Assert.assertEquals((int)command.getFailureCount(), (int)60);
        Assert.assertTrue((watch.stop().elapsedTime(TimeUnit.MILLISECONDS) >= 98L ? 1 : 0) != 0);
    }

    public void testQueueDeletedRecentlyRetriesWhen60DoesntTry() {
        SQSErrorRetryHandler retry = new SQSErrorRetryHandler((AWSUtils)EasyMock.createMock(AWSUtils.class), (BackoffLimitedRetryHandler)EasyMock.createMock(BackoffLimitedRetryHandler.class), (Set)ImmutableSet.of(), 60, 100L);
        HttpCommand command = this.createHttpCommandForFailureCount(60);
        Stopwatch watch = new Stopwatch().start();
        Assert.assertFalse((boolean)retry.shouldRetryRequestOnError(command, this.response, this.error));
        Assert.assertEquals((int)command.getFailureCount(), (int)61);
        Assert.assertTrue((watch.stop().elapsedTime(TimeUnit.MILLISECONDS) < 100L ? 1 : 0) != 0);
    }

    HttpCommand createHttpCommandForFailureCount(int failureCount) {
        HttpCommand command = new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://localhost").build());
        while (command.getFailureCount() != failureCount) {
            command.incrementFailureCount();
        }
        return command;
    }
}

