/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.ChefAsyncApi;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.compute.internal.BaseComputeServiceIntegratedChefClientLiveTest;
import org.jclouds.chef.predicates.CookbookVersionPredicates;
import org.jclouds.chef.util.RunListBuilder;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.RestContext;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ChefComputeServiceLiveTest")
public class ChefComputeServiceLiveTest
extends BaseComputeServiceIntegratedChefClientLiveTest {
    private String group;
    private String clientName;
    private Iterable<? extends NodeMetadata> nodes;

    @Test
    public void testCanUpdateRunList() throws IOException {
        String recipe = "apache2";
        Iterable cookbookVersions = ((ChefContext)this.view).getChefService().listCookbookVersions();
        if (Iterables.any((Iterable)cookbookVersions, (Predicate)CookbookVersionPredicates.containsRecipe((String)recipe))) {
            List runList = new RunListBuilder().addRecipe(recipe).build();
            ((ChefContext)this.view).getChefService().updateRunListForGroup((Iterable)runList, this.group);
            Assert.assertEquals((Collection)((ChefContext)this.view).getChefService().getRunListForGroup(this.group), (Collection)runList);
        } else assert (false) : String.format("recipe %s not in %s", recipe, cookbookVersions);
        assert (Iterables.any((Iterable)cookbookVersions, (Predicate)CookbookVersionPredicates.containsRecipe((String)"apache2::mod_proxy")));
        assert (Iterables.any((Iterable)cookbookVersions, (Predicate)CookbookVersionPredicates.containsRecipes((String[])new String[]{"apache2", "apache2::mod_proxy", "apache2::mod_proxy_http"})));
        assert (!Iterables.any((Iterable)cookbookVersions, (Predicate)CookbookVersionPredicates.containsRecipe((String)"apache2::bar")));
        assert (!Iterables.any((Iterable)cookbookVersions, (Predicate)CookbookVersionPredicates.containsRecipe((String)"foo::bar")));
    }

    @Test(dependsOnMethods={"testCanUpdateRunList"})
    public void testRunNodesWithBootstrap() throws IOException {
        Statement bootstrap = ((ChefContext)this.view).getChefService().createBootstrapScriptForGroup(this.group);
        try {
            this.nodes = this.computeContext.getComputeService().createNodesInGroup(this.group, 1, TemplateOptions.Builder.runScript((Statement)bootstrap));
        }
        catch (RunNodesException e) {
            this.nodes = Iterables.concat((Iterable)e.getSuccessfulNodes(), e.getNodeErrors().keySet());
        }
        for (NodeMetadata nodeMetadata : this.nodes) {
            URI uri = URI.create("http://" + (String)Iterables.getLast((Iterable)nodeMetadata.getPublicAddresses()));
            InputStream content = this.computeContext.utils().http().get(uri);
            String string = Strings2.toStringAndClose((InputStream)content);
            assert (string.indexOf("It works!") >= 0) : string;
        }
    }

    @Override
    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        if (this.computeContext != null) {
            this.computeContext.getComputeService().destroyNodesMatching(NodePredicates.inGroup((String)this.group));
        }
        if (this.context != null) {
            ((ChefContext)this.view).getChefService().cleanupStaleNodesAndClients(this.group + "-", 1);
            ChefApi api = (ChefApi)((RestContext)((ChefContext)this.view).unwrap((TypeToken)new TypeToken<RestContext<ChefApi, ChefAsyncApi>>(){})).getApi();
            if (this.clientName != null && api.clientExists(this.clientName)) {
                api.deleteClient(this.clientName);
            }
            this.context.close();
        }
        super.tearDownContext();
    }

    protected TypeToken<ChefContext> viewType() {
        return Reflection2.typeToken(ChefContext.class);
    }
}

