/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.compute.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import com.google.inject.Module;
import java.io.Closeable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.BaseViewLiveTest;
import org.jclouds.chef.ChefContext;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.io.CopyInputStreamInputSupplierMap;
import org.jclouds.rest.config.CredentialStoreModule;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.AfterClass;

public abstract class BaseComputeServiceIntegratedChefClientLiveTest
extends BaseViewLiveTest<ChefContext> {
    protected TemplateBuilderSpec template;
    protected LoginCredentials loginCredentials = LoginCredentials.builder().user("root").build();
    protected Module credentialStoreModule = new CredentialStoreModule((Map)new CopyInputStreamInputSupplierMap(new ConcurrentHashMap()));
    private String computeProvider;
    protected volatile ComputeServiceContext computeContext;

    protected Properties setupComputeProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        this.computeProvider = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.provider");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.identity");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.credential");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.endpoint");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.api-version");
        this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.build-version");
        String spec = this.setIfTestSystemPropertyPresent(overrides, this.provider + ".compute.template");
        if (spec != null) {
            this.template = TemplateBuilderSpec.parse((String)spec);
            if (this.template.getLoginUser() != null) {
                Iterable userPass = Splitter.on((char)':').split((CharSequence)this.template.getLoginUser());
                LoginCredentials.Builder loginCredentialsBuilder = LoginCredentials.builder();
                loginCredentialsBuilder.user((String)Iterables.get((Iterable)userPass, (int)0));
                if (Iterables.size((Iterable)userPass) == 2) {
                    loginCredentialsBuilder.password((String)Iterables.get((Iterable)userPass, (int)1));
                }
                if (this.template.getAuthenticateSudo() != null) {
                    loginCredentialsBuilder.authenticateSudo(this.template.getAuthenticateSudo().booleanValue());
                }
                this.loginCredentials = loginCredentialsBuilder.build();
            }
        }
        return overrides;
    }

    protected Iterable<Module> setupModules() {
        return ImmutableSet.of((Object)this.getLoggingModule(), (Object)this.credentialStoreModule, (Object)this.getSshModule());
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void initializeContext() {
        super.initializeContext();
        this.computeContext = (ComputeServiceContext)ContextBuilder.newBuilder((String)this.computeProvider).modules(this.setupModules()).overrides(this.setupComputeProperties()).buildView(ComputeServiceContext.class);
    }

    @AfterClass(groups={"integration", "live"})
    protected void tearDownContext() {
        Closeables.closeQuietly((Closeable)this.computeContext);
        super.tearDownContext();
    }
}

