/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.servlet.suppliers;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.easymock.classextension.EasyMock;
import org.jclouds.chef.servlet.functions.InitParamsToProperties;
import org.jclouds.json.Json;
import org.jclouds.json.config.GsonModule;
import org.jclouds.ohai.servlet.config.ServletOhaiModule;
import org.jclouds.ohai.servlet.suppliers.ServletContextInfoSupplier;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ServletContextInfoSupplierTest {
    @Test
    public void testApply() {
        final ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        final InitParamsToProperties converter = (InitParamsToProperties)EasyMock.createMock(InitParamsToProperties.class);
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        org.easymock.EasyMock.expect((Object)servletContext.getContextPath()).andReturn((Object)"path");
        org.easymock.EasyMock.expect((Object)servletContext.getServerInfo()).andReturn((Object)"serverinfo");
        org.easymock.EasyMock.expect((Object)converter.apply(servletContext)).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{servletContext});
        EasyMock.replay((Object[])new Object[]{converter});
        Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule(), new ServletOhaiModule(){

            @Provides
            protected ServletContext provideServletContext() {
                return servletContext;
            }

            @Provides
            protected InitParamsToProperties provideInitParamsToProperties() {
                return converter;
            }
        }});
        Json json = (Json)injector.getInstance(Json.class);
        ServletContextInfoSupplier ohai = (ServletContextInfoSupplier)injector.getInstance(ServletContextInfoSupplier.class);
        Assert.assertEquals((String)json.toJson((Object)ohai.get()), (String)"{\"path\":{\"server_info\":\"serverinfo\",\"init_params\":{\"foo\":\"bar\"}}}");
    }

    @Test
    public void testApplyNullPath() {
        final ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        final InitParamsToProperties converter = (InitParamsToProperties)EasyMock.createMock(InitParamsToProperties.class);
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        org.easymock.EasyMock.expect((Object)servletContext.getContextPath()).andReturn(null);
        org.easymock.EasyMock.expect((Object)servletContext.getServerInfo()).andReturn((Object)"serverinfo");
        org.easymock.EasyMock.expect((Object)converter.apply(servletContext)).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{servletContext});
        EasyMock.replay((Object[])new Object[]{converter});
        Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule(), new ServletOhaiModule(){

            @Provides
            protected ServletContext provideServletContext() {
                return servletContext;
            }

            @Provides
            protected InitParamsToProperties provideInitParamsToProperties() {
                return converter;
            }
        }});
        Json json = (Json)injector.getInstance(Json.class);
        ServletContextInfoSupplier ohai = (ServletContextInfoSupplier)injector.getInstance(ServletContextInfoSupplier.class);
        Assert.assertEquals((String)json.toJson((Object)ohai.get()), (String)"{\"/\":{\"server_info\":\"serverinfo\",\"init_params\":{\"foo\":\"bar\"}}}");
    }

    @Test
    public void testApplyEmptyPath() {
        final ServletContext servletContext = (ServletContext)EasyMock.createMock(ServletContext.class);
        final InitParamsToProperties converter = (InitParamsToProperties)EasyMock.createMock(InitParamsToProperties.class);
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        org.easymock.EasyMock.expect((Object)servletContext.getContextPath()).andReturn((Object)"");
        org.easymock.EasyMock.expect((Object)servletContext.getServerInfo()).andReturn((Object)"serverinfo");
        org.easymock.EasyMock.expect((Object)converter.apply(servletContext)).andReturn((Object)props);
        EasyMock.replay((Object[])new Object[]{servletContext});
        EasyMock.replay((Object[])new Object[]{converter});
        Injector injector = Guice.createInjector((Module[])new Module[]{new GsonModule(), new ServletOhaiModule(){

            @Provides
            protected ServletContext provideServletContext() {
                return servletContext;
            }

            @Provides
            protected InitParamsToProperties provideInitParamsToProperties() {
                return converter;
            }
        }});
        Json json = (Json)injector.getInstance(Json.class);
        ServletContextInfoSupplier ohai = (ServletContextInfoSupplier)injector.getInstance(ServletContextInfoSupplier.class);
        Assert.assertEquals((String)json.toJson((Object)ohai.get()), (String)"{\"/\":{\"server_info\":\"serverinfo\",\"init_params\":{\"foo\":\"bar\"}}}");
    }
}

