/**
 *
 * Copyright (C) 2010 Cloud Conscious, LLC. <info@cloudconscious.com>
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */

package org.jclouds.gogrid.domain;


/**
 * Server's state transition.
 * 
 * Using this value, server's state will be changed to one of the following:
 * <ul>
 * <li>Start</li>
 * <li>Stop</li>
 * <li>Restart</li>
 * </ul>
 * 
 * @see org.jclouds.gogrid.services.GridServerClient#power(String, PowerCommand)
 * @see <a href="http://wiki.gogrid.com/wiki/index.php/API:grid.server.power" />
 * 
 * @author Oleksiy Yarmula
 */
public enum PowerCommand {
   START, STOP /* NOTE: This is a hard shutdown, equivalent to powering off a server. */, RESTART;

   @Override
   public String toString() {
      return name().toLowerCase();
   }
}
