/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.jclouds.domain.Credentials;
import org.jclouds.gogrid.GoGridAsyncClient;
import org.jclouds.gogrid.GoGridClient;
import org.jclouds.gogrid.GoGridResponseException;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.LoadBalancer;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.PowerCommand;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageType;
import org.jclouds.gogrid.options.AddLoadBalancerOptions;
import org.jclouds.gogrid.options.AddServerOptions;
import org.jclouds.gogrid.options.GetImageListOptions;
import org.jclouds.gogrid.options.GetServerListOptions;
import org.jclouds.gogrid.predicates.LoadBalancerLatestJobCompleted;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.net.IPSocket;
import org.jclouds.predicates.RetryablePredicate;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.ssh.jsch.JschSshClient;
import org.jclouds.ssh.jsch.predicates.InetSocketAddressConnect;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.TestException;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(enabled=false, groups={"live"}, testName="gogrid.GoGridLiveTest")
public class GoGridLiveTestDisabled {
    private GoGridClient client;
    private RetryablePredicate<Server> serverLatestJobCompleted;
    private RetryablePredicate<LoadBalancer> loadBalancerLatestJobCompleted;
    private List<String> serversToDeleteAfterTheTests = new ArrayList<String>();
    private List<String> loadBalancersToDeleteAfterTest = new ArrayList<String>();
    private RestContext<GoGridClient, GoGridAsyncClient> context;
    protected String provider = "gogrid";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;

    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".credential"), (Object)("test." + this.provider + ".credential"));
        this.endpoint = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".endpoint"), (Object)("test." + this.provider + ".endpoint"));
        this.apiversion = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".apiversion"), (Object)("test." + this.provider + ".apiversion"));
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        overrides.setProperty(this.provider + ".credential", this.credential);
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        this.context = new RestContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule()), overrides);
        this.client = (GoGridClient)this.context.getApi();
        this.serverLatestJobCompleted = new RetryablePredicate((Predicate)new ServerLatestJobCompleted(this.client.getJobServices()), 800L, 20L, TimeUnit.SECONDS);
        this.loadBalancerLatestJobCompleted = new RetryablePredicate((Predicate)new LoadBalancerLatestJobCompleted(this.client.getJobServices()), 800L, 20L, TimeUnit.SECONDS);
    }

    @Test(enabled=true)
    public void testDescriptionIs500Characters() {
        String nameOfServer = "Description" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = this.client.getIpServices().getUnassignedPublicIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        String ram = ((Option)Iterables.get((Iterable)this.client.getServerServices().getRamSizes(), (int)0)).getName();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 500; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        Server createdServer = this.client.getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, availableIp.getIp(), new AddServerOptions[]{new AddServerOptions().withDescription(description)});
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Assert.assertEquals((String)((Server)Iterables.getLast((Iterable)this.client.getServerServices().getServersByName(new String[]{nameOfServer}))).getDescription(), (String)description);
    }

    @Test(enabled=true)
    public void testServerLifecycle() {
        int serverCountBeforeTest = this.client.getServerServices().getServerList(new GetServerListOptions[0]).size();
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = this.client.getIpServices().getUnassignedPublicIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        String ram = ((Option)Iterables.get((Iterable)this.client.getServerServices().getRamSizes(), (int)0)).getName();
        Server createdServer = this.client.getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, availableIp.getIp(), new AddServerOptions[0]);
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Set response = this.client.getServerServices().getServersByName(new String[]{nameOfServer});
        assert (response.size() == 1);
        this.client.getServerServices().power(nameOfServer, PowerCommand.RESTART);
        Set jobs = this.client.getJobServices().getJobsForObjectName(nameOfServer);
        assert ("RestartVirtualServer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        int serverCountAfterAddingOneServer = this.client.getServerServices().getServerList(new GetServerListOptions[0]).size();
        assert (serverCountAfterAddingOneServer == serverCountBeforeTest + 1) : "There should be +1 increase in the number of servers since the test started";
        this.client.getServerServices().deleteByName(nameOfServer);
        jobs = this.client.getJobServices().getJobsForObjectName(nameOfServer);
        assert ("DeleteVirtualServer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        int serverCountAfterDeletingTheServer = this.client.getServerServices().getServerList(new GetServerListOptions[0]).size();
        assert (serverCountAfterDeletingTheServer == serverCountBeforeTest) : "There should be the same # of servers as since the test started";
        assert (this.client.getIpServices().getUnassignedIpList().contains(availableIp));
    }

    @Test(dependsOnMethods={"testServerLifecycle"}, enabled=true)
    public void testJobs() {
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = this.client.getIpServices().getUnassignedPublicIpList();
        String ram = ((Option)Iterables.get((Iterable)this.client.getServerServices().getRamSizes(), (int)0)).getName();
        Server createdServer = this.client.getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", ram, ((Ip)Iterables.getLast((Iterable)availableIps)).getIp(), new AddServerOptions[0]);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        this.client.getServerServices().power(nameOfServer, PowerCommand.RESTART);
        Set jobs = this.client.getJobServices().getJobsForObjectName(nameOfServer);
        Job latestJob = (Job)Iterables.getLast((Iterable)jobs);
        Long latestJobId = latestJob.getId();
        Job latestJobFetched = (Job)Iterables.getOnlyElement((Iterable)this.client.getJobServices().getJobsById(new long[]{latestJobId}));
        assert (latestJob.equals((Object)latestJobFetched)) : "Job and its reprentation found by ID don't match";
        long[] idsOfAllJobs = new long[jobs.size()];
        int i = 0;
        for (Job job : jobs) {
            idsOfAllJobs[i++] = job.getId();
        }
        Set jobsFetched = this.client.getJobServices().getJobsById(idsOfAllJobs);
        assert (jobsFetched.size() == jobs.size()) : String.format("Number of jobs fetched by ids doesn't match the number of jobs requested. Requested/expected: %d. Found: %d.", jobs.size(), jobsFetched.size());
        this.client.getServerServices().deleteByName(nameOfServer);
    }

    @Test(enabled=true)
    public void testLoadBalancerLifecycle() {
        int lbCountBeforeTest = this.client.getLoadBalancerServices().getLoadBalancerList().size();
        String nameOfLoadBalancer = "LoadBalancer" + String.valueOf(new Date().getTime()).substring(6);
        this.loadBalancersToDeleteAfterTest.add(nameOfLoadBalancer);
        Set availableIps = this.client.getIpServices().getUnassignedPublicIpList();
        if (availableIps.size() < 4) {
            throw new SkipException("Not enough available IPs (4 needed) to run the test");
        }
        Iterator ipIterator = availableIps.iterator();
        Ip vip = (Ip)ipIterator.next();
        Ip realIp1 = (Ip)ipIterator.next();
        Ip realIp2 = (Ip)ipIterator.next();
        Ip realIp3 = (Ip)ipIterator.next();
        AddLoadBalancerOptions options = new AddLoadBalancerOptions.Builder().create(LoadBalancerType.LEAST_CONNECTED, LoadBalancerPersistenceType.SOURCE_ADDRESS);
        LoadBalancer createdLoadBalancer = this.client.getLoadBalancerServices().addLoadBalancer(nameOfLoadBalancer, new IpPortPair(vip, 80), Arrays.asList(new IpPortPair(realIp1, 80), new IpPortPair(realIp2, 80)), new AddLoadBalancerOptions[]{options});
        Assert.assertNotNull((Object)createdLoadBalancer);
        assert (this.loadBalancerLatestJobCompleted.apply((Object)createdLoadBalancer));
        Set response = this.client.getLoadBalancerServices().getLoadBalancersByName(new String[]{nameOfLoadBalancer});
        assert (response.size() == 1);
        createdLoadBalancer = (LoadBalancer)Iterables.getOnlyElement((Iterable)response);
        Assert.assertNotNull((Object)createdLoadBalancer.getRealIpList());
        Assert.assertEquals((int)createdLoadBalancer.getRealIpList().size(), (int)2);
        Assert.assertNotNull((Object)createdLoadBalancer.getVirtualIp());
        Assert.assertEquals((String)createdLoadBalancer.getVirtualIp().getIp().getIp(), (String)vip.getIp());
        LoadBalancer editedLoadBalancer = this.client.getLoadBalancerServices().editLoadBalancerNamed(nameOfLoadBalancer, Arrays.asList(new IpPortPair(realIp3, 8181)));
        assert (this.loadBalancerLatestJobCompleted.apply((Object)editedLoadBalancer));
        Assert.assertNotNull((Object)editedLoadBalancer.getRealIpList());
        Assert.assertEquals((int)editedLoadBalancer.getRealIpList().size(), (int)1);
        Assert.assertEquals((String)((IpPortPair)Iterables.getOnlyElement((Iterable)editedLoadBalancer.getRealIpList())).getIp().getIp(), (String)realIp3.getIp());
        int lbCountAfterAddingOneServer = this.client.getLoadBalancerServices().getLoadBalancerList().size();
        assert (lbCountAfterAddingOneServer == lbCountBeforeTest + 1) : "There should be +1 increase in the number of load balancers since the test started";
        this.client.getLoadBalancerServices().deleteByName(nameOfLoadBalancer);
        Set jobs = this.client.getJobServices().getJobsForObjectName(nameOfLoadBalancer);
        assert ("DeleteLoadBalancer".equals(((Job)Iterables.getLast((Iterable)jobs)).getCommand().getName()));
        assert (this.loadBalancerLatestJobCompleted.apply((Object)createdLoadBalancer));
        int lbCountAfterDeletingTheServer = this.client.getLoadBalancerServices().getLoadBalancerList().size();
        assert (lbCountAfterDeletingTheServer == lbCountBeforeTest) : "There should be the same # of load balancers as since the test started";
    }

    @Test(enabled=true)
    public void testImageLifecycle() {
        GetImageListOptions options = new GetImageListOptions.Builder().publicDatabaseServers();
        Set images = this.client.getImageServices().getImageList(new GetImageListOptions[]{options});
        Predicate<ServerImage> isDatabaseServer = new Predicate<ServerImage>(){

            public boolean apply(@Nullable ServerImage serverImage) {
                return ((ServerImage)Preconditions.checkNotNull((Object)serverImage)).getType() == ServerImageType.DATABASE_SERVER;
            }
        };
        assert (Iterables.all((Iterable)images, (Predicate)isDatabaseServer)) : "All of the images should've been of database type";
        ServerImage image = (ServerImage)Iterables.getLast((Iterable)images);
        ServerImage imageFromServer = (ServerImage)Iterables.getOnlyElement((Iterable)this.client.getImageServices().getImagesByName(new String[]{image.getName()}));
        Assert.assertEquals((Object)image, (Object)imageFromServer);
        try {
            this.client.getImageServices().editImageDescription(image.getName(), "newDescription");
            throw new TestException("An exception hasn't been thrown where expected; expected GoGridResponseException");
        }
        catch (GoGridResponseException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("GoGridIllegalArgumentException"));
            return;
        }
    }

    @Test(enabled=true)
    public void testShellAccess() throws IOException {
        String nameOfServer = "Server" + String.valueOf(new Date().getTime()).substring(6);
        this.serversToDeleteAfterTheTests.add(nameOfServer);
        Set availableIps = this.client.getIpServices().getUnassignedIpList();
        Ip availableIp = (Ip)Iterables.getLast((Iterable)availableIps);
        Server createdServer = this.client.getServerServices().addServer(nameOfServer, "GSI-f8979644-e646-4711-ad58-d98a5fa3612c", "1", availableIp.getIp(), new AddServerOptions[0]);
        Assert.assertNotNull((Object)createdServer);
        assert (this.serverLatestJobCompleted.apply((Object)createdServer));
        Set response = this.client.getServerServices().getServersByName(new String[]{nameOfServer});
        assert (response.size() == 1);
        createdServer = (Server)Iterables.getOnlyElement((Iterable)response);
        Map credsMap = this.client.getServerServices().getServerCredentialsList();
        Credentials instanceCredentials = (Credentials)credsMap.get(createdServer.getName());
        Assert.assertNotNull((Object)instanceCredentials);
        IPSocket socket = new IPSocket(createdServer.getIp().getIp(), 22);
        RetryablePredicate socketOpen = new RetryablePredicate((Predicate)new InetSocketAddressConnect(), 180L, 5L, TimeUnit.SECONDS);
        socketOpen.apply((Object)socket);
        JschSshClient sshClient = new JschSshClient(new BackoffLimitedRetryHandler(), socket, 60000, instanceCredentials.identity, instanceCredentials.credential, null);
        sshClient.connect();
        String output = sshClient.exec("df").getOutput();
        Assert.assertTrue((boolean)output.contains("Filesystem"), (String)("The output should've contained filesystem information, but it didn't. Output: " + output));
        sshClient.disconnect();
        Assert.assertEquals((Object)this.client.getServerServices().getServerCredentials(createdServer.getId()), (Object)instanceCredentials);
        try {
            Assert.assertEquals((Object)this.client.getServerServices().getServerCredentials(Long.MAX_VALUE), null);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
        }
        this.client.getServerServices().deleteByName(nameOfServer);
    }

    @AfterTest
    public void cleanup() {
        for (String serverName : this.serversToDeleteAfterTheTests) {
            try {
                this.client.getServerServices().deleteByName(serverName);
            }
            catch (Exception e) {}
        }
        for (String loadBalancerName : this.loadBalancersToDeleteAfterTest) {
            try {
                this.client.getLoadBalancerServices().deleteByName(loadBalancerName);
            }
            catch (Exception exception) {}
        }
    }
}

