/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute;

import org.jclouds.compute.BaseComputeServiceLiveTest;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, sequential=true, testName="gogrid.GoGridComputeServiceLiveTest")
public class GoGridComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public GoGridComputeServiceLiveTest() {
        this.provider = "gogrid";
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = this.client.templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"1");
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)0.5);
    }

    protected JschSshClientModule getSshModule() {
        return new JschSshClientModule();
    }

    public void testAssignability() throws Exception {
        RestContext goGridContext = new ComputeServiceContextFactory().createContext(this.provider, this.identity, this.credential).getProviderSpecificContext();
    }
}

